/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.data.publisher;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataPublisherConfiguration {
    private static final Log log = LogFactory.getLog(DataPublisherConfiguration.class);
    private static final String ENABLE_DATA_PUBLISHER = "enable.data.publisher";
    private static final String MONITORING_SERVER_IP = "monitoring.server.ip";
    private static final String MONITORING_SERVER_PORT = "monitoring.server.port";
    private static final String MONITORING_SERVER_SECURE_PORT = "monitoring.server.secure.port";
    private static final String MONITORING_SERVER_ADMIN_USERNAME = "monitoring.server.admin.username";
    private static final String MONITORING_SERVER_ADMIN_PASSWORD = "monitoring.server.admin.password";
    private boolean enable;
    private String monitoringServerUrl;
    private String monitoringServerIp;
    private String monitoringServerPort;
    private String monitoringServerSecurePort;
    private String adminUsername;
    private String adminPassword;
    private static volatile DataPublisherConfiguration dataPublisherConfiguration;

    private DataPublisherConfiguration() {
        this.readConfig();
    }

    private void readConfig() {
        String enabled = System.getProperty(ENABLE_DATA_PUBLISHER);
        this.setEnable(Boolean.parseBoolean(enabled));
        if (!this.isEnabled()) {
            log.info((Object)"Data Publisher disabled");
            return;
        }
        log.info((Object)"Data publishing is enabled");
        this.monitoringServerIp = System.getProperty(MONITORING_SERVER_IP);
        if (StringUtils.isBlank((CharSequence)this.monitoringServerIp)) {
            throw new RuntimeException("System property not found: monitoring.server.ip");
        }
        this.monitoringServerPort = System.getProperty(MONITORING_SERVER_PORT);
        if (StringUtils.isBlank((CharSequence)this.monitoringServerPort)) {
            throw new RuntimeException("System property not found: monitoring.server.port");
        }
        this.monitoringServerUrl = "tcp://" + this.monitoringServerIp + ":" + this.monitoringServerPort;
        this.monitoringServerSecurePort = System.getProperty(MONITORING_SERVER_SECURE_PORT);
        if (StringUtils.isBlank((CharSequence)this.monitoringServerSecurePort)) {
            throw new RuntimeException("System property not found: monitoring.server.secure.port");
        }
        this.adminUsername = System.getProperty(MONITORING_SERVER_ADMIN_USERNAME);
        if (StringUtils.isBlank((CharSequence)this.adminUsername)) {
            throw new RuntimeException("System property not found: monitoring.server.admin.username");
        }
        this.adminPassword = System.getProperty(MONITORING_SERVER_ADMIN_PASSWORD);
        if (StringUtils.isBlank((CharSequence)this.adminPassword)) {
            throw new RuntimeException("System property not found: monitoring.server.admin.password");
        }
        log.info((Object)"Data Publisher configuration initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataPublisherConfiguration getInstance() {
        if (dataPublisherConfiguration != null) return dataPublisherConfiguration;
        Class<DataPublisherConfiguration> clazz = DataPublisherConfiguration.class;
        synchronized (DataPublisherConfiguration.class) {
            if (dataPublisherConfiguration != null) return dataPublisherConfiguration;
            dataPublisherConfiguration = new DataPublisherConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataPublisherConfiguration;
        }
    }

    public String getMonitoringServerUrl() {
        return this.monitoringServerUrl;
    }

    public void setMonitoringServerUrl(String monitoringServerUrl) {
        this.monitoringServerUrl = monitoringServerUrl;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getMonitoringServerPort() {
        return this.monitoringServerPort;
    }

    public void setMonitoringServerPort(String monitoringServerPort) {
        this.monitoringServerPort = monitoringServerPort;
    }

    public String getMonitoringServerSecurePort() {
        return this.monitoringServerSecurePort;
    }

    public void setMonitoringServerSecurePort(String monitoringServerSecurePort) {
        this.monitoringServerSecurePort = monitoringServerSecurePort;
    }

    public String getMonitoringServerIp() {
        return this.monitoringServerIp;
    }

    public void setMonitoringServerIp(String monitoringServerIp) {
        this.monitoringServerIp = monitoringServerIp;
    }
}

