/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.event.publisher;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.statistics.publisher.HealthStatisticsNotifier;
import org.apache.stratos.cartridge.agent.util.CartridgeAgentUtils;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.instance.status.InstanceActivatedEvent;
import org.apache.stratos.messaging.event.instance.status.InstanceMaintenanceModeEvent;
import org.apache.stratos.messaging.event.instance.status.InstanceReadyToShutdownEvent;
import org.apache.stratos.messaging.event.instance.status.InstanceStartedEvent;
import org.apache.stratos.messaging.util.MessagingUtil;

public class CartridgeAgentEventPublisher {
    private static final Log log = LogFactory.getLog(CartridgeAgentEventPublisher.class);
    private static boolean started;
    private static boolean activated;
    private static boolean readyToShutdown;
    private static boolean maintenance;

    public static void publishInstanceStartedEvent() {
        if (!CartridgeAgentEventPublisher.isStarted()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Publishing instance started event");
            }
            InstanceStartedEvent event = new InstanceStartedEvent(CartridgeAgentConfiguration.getInstance().getApplicationId(), CartridgeAgentConfiguration.getInstance().getServiceName(), CartridgeAgentConfiguration.getInstance().getClusterId(), CartridgeAgentConfiguration.getInstance().getMemberId(), CartridgeAgentConfiguration.getInstance().getClusterInstanceId(), CartridgeAgentConfiguration.getInstance().getNetworkPartitionId(), CartridgeAgentConfiguration.getInstance().getPartitionId());
            String topic = MessagingUtil.getMessageTopicName((Event)event);
            EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)topic);
            eventPublisher.publish((Event)event);
            CartridgeAgentEventPublisher.setStarted(true);
            if (log.isInfoEnabled()) {
                log.info((Object)"Instance started event published");
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Instance already started");
        }
    }

    public static void publishInstanceActivatedEvent() {
        if (!CartridgeAgentEventPublisher.isActivated()) {
            List<Integer> ports = CartridgeAgentConfiguration.getInstance().getPorts();
            String listenAddress = CartridgeAgentConfiguration.getInstance().getListenAddress();
            boolean portsActivated = CartridgeAgentUtils.waitUntilPortsActive(listenAddress, ports);
            if (portsActivated) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Publishing instance activated event");
                }
                InstanceActivatedEvent event = new InstanceActivatedEvent(CartridgeAgentConfiguration.getInstance().getServiceName(), CartridgeAgentConfiguration.getInstance().getClusterId(), CartridgeAgentConfiguration.getInstance().getMemberId(), CartridgeAgentConfiguration.getInstance().getInstanceId(), CartridgeAgentConfiguration.getInstance().getClusterInstanceId(), CartridgeAgentConfiguration.getInstance().getNetworkPartitionId(), CartridgeAgentConfiguration.getInstance().getPartitionId());
                String topic = MessagingUtil.getMessageTopicName((Event)event);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)topic);
                eventPublisher.publish((Event)event);
                if (log.isInfoEnabled()) {
                    log.info((Object)"Instance activated event published");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Starting health statistics notifier");
                }
                Thread thread = new Thread(new HealthStatisticsNotifier());
                thread.start();
                CartridgeAgentEventPublisher.setActivated(true);
                if (log.isInfoEnabled()) {
                    log.info((Object)"Health statistics notifier started");
                }
            } else if (log.isInfoEnabled()) {
                String portsStr = "";
                for (Integer port : ports) {
                    portsStr = portsStr + port + ", ";
                }
                log.error((Object)String.format("Ports activation timed out. Aborting InstanceActivatedEvent publishing. [IPAddress] %s [Ports] %s", listenAddress, portsStr));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Instance already activated");
        }
    }

    public static void publishInstanceReadyToShutdownEvent() {
        if (!CartridgeAgentEventPublisher.isReadyToShutdown()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Publishing instance activated event");
            }
            InstanceReadyToShutdownEvent event = new InstanceReadyToShutdownEvent(CartridgeAgentConfiguration.getInstance().getServiceName(), CartridgeAgentConfiguration.getInstance().getClusterId(), CartridgeAgentConfiguration.getInstance().getMemberId(), CartridgeAgentConfiguration.getInstance().getClusterInstanceId(), CartridgeAgentConfiguration.getInstance().getNetworkPartitionId(), CartridgeAgentConfiguration.getInstance().getPartitionId());
            String topic = MessagingUtil.getMessageTopicName((Event)event);
            EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)topic);
            eventPublisher.publish((Event)event);
            CartridgeAgentEventPublisher.setReadyToShutdown(true);
            if (log.isInfoEnabled()) {
                log.info((Object)"Instance ReadyToShutDown event published");
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Instance already sent ReadyToShutDown event....");
        }
    }

    public static void publishMaintenanceModeEvent() {
        if (!CartridgeAgentEventPublisher.isMaintenance()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Publishing instance maintenance mode event");
            }
            InstanceMaintenanceModeEvent event = new InstanceMaintenanceModeEvent(CartridgeAgentConfiguration.getInstance().getServiceName(), CartridgeAgentConfiguration.getInstance().getClusterId(), CartridgeAgentConfiguration.getInstance().getMemberId(), CartridgeAgentConfiguration.getInstance().getClusterInstanceId(), CartridgeAgentConfiguration.getInstance().getNetworkPartitionId(), CartridgeAgentConfiguration.getInstance().getPartitionId());
            String topic = MessagingUtil.getMessageTopicName((Event)event);
            EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)topic);
            eventPublisher.publish((Event)event);
            CartridgeAgentEventPublisher.setMaintenance(true);
            if (log.isInfoEnabled()) {
                log.info((Object)"Instance Maintenance mode event published");
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Instance already in a Maintenance mode....");
        }
    }

    public static boolean isStarted() {
        return started;
    }

    public static void setStarted(boolean started) {
        CartridgeAgentEventPublisher.started = started;
    }

    public static boolean isActivated() {
        return activated;
    }

    public static void setActivated(boolean activated) {
        CartridgeAgentEventPublisher.activated = activated;
    }

    public static boolean isReadyToShutdown() {
        return readyToShutdown;
    }

    public static void setReadyToShutdown(boolean readyToShutdown) {
        CartridgeAgentEventPublisher.readyToShutdown = readyToShutdown;
    }

    public static boolean isMaintenance() {
        return maintenance;
    }

    public static void setMaintenance(boolean maintenance) {
        CartridgeAgentEventPublisher.maintenance = maintenance;
    }
}

