/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.extensions;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.RepositoryInformation;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.impl.GitBasedArtifactRepository;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.event.publisher.CartridgeAgentEventPublisher;
import org.apache.stratos.cartridge.agent.extensions.ExtensionHandler;
import org.apache.stratos.cartridge.agent.util.CartridgeAgentUtils;
import org.apache.stratos.cartridge.agent.util.ExtensionUtils;
import org.apache.stratos.messaging.domain.tenant.Tenant;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.application.signup.ApplicationSignUpRemovedEvent;
import org.apache.stratos.messaging.event.domain.mapping.DomainMappingAddedEvent;
import org.apache.stratos.messaging.event.domain.mapping.DomainMappingRemovedEvent;
import org.apache.stratos.messaging.event.instance.notifier.ArtifactUpdatedEvent;
import org.apache.stratos.messaging.event.instance.notifier.InstanceCleanupClusterEvent;
import org.apache.stratos.messaging.event.instance.notifier.InstanceCleanupMemberEvent;
import org.apache.stratos.messaging.event.tenant.CompleteTenantEvent;
import org.apache.stratos.messaging.event.tenant.TenantSubscribedEvent;
import org.apache.stratos.messaging.event.tenant.TenantUnSubscribedEvent;
import org.apache.stratos.messaging.event.topology.CompleteTopologyEvent;
import org.apache.stratos.messaging.event.topology.MemberActivatedEvent;
import org.apache.stratos.messaging.event.topology.MemberCreatedEvent;
import org.apache.stratos.messaging.event.topology.MemberInitializedEvent;
import org.apache.stratos.messaging.event.topology.MemberStartedEvent;
import org.apache.stratos.messaging.event.topology.MemberSuspendedEvent;
import org.apache.stratos.messaging.event.topology.MemberTerminatedEvent;
import org.apache.stratos.messaging.message.receiver.tenant.TenantManager;

public class DefaultExtensionHandler
implements ExtensionHandler {
    private static final Log log = LogFactory.getLog(DefaultExtensionHandler.class);
    private static final Gson gson = new Gson();
    private static final Type memberType = new TypeToken<Collection<Member>>(){}.getType();
    private static final Type tenantType = new TypeToken<Collection<Tenant>>(){}.getType();
    private static final Type serviceType = new TypeToken<Collection<Service>>(){}.getType();

    @Override
    public void onInstanceStartedEvent() {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Processing instance started event...");
                }
                if (CartridgeAgentConfiguration.getInstance().isMultitenant()) {
                    ExtensionUtils.executeCopyArtifactsExtension(CartridgeAgentConfiguration.getInstance().getAppPath() + "/repository/deployment/server/", "/tmp/-1234/");
                }
                HashMap<String, String> env = new HashMap<String, String>();
                ExtensionUtils.executeInstanceStartedExtension(env);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Error processing instance started event", (Throwable)e);
            }
        }
    }

    @Override
    public void onInstanceActivatedEvent() {
        ExtensionUtils.executeInstanceActivatedExtension();
    }

    @Override
    public void onArtifactUpdatedEvent(ArtifactUpdatedEvent artifactUpdatedEvent) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Artifact update event received: [tenant] %s [cluster] %s [status] %s", artifactUpdatedEvent.getTenantId(), artifactUpdatedEvent.getClusterId(), artifactUpdatedEvent.getStatus()));
        }
        String clusterIdInMessage = artifactUpdatedEvent.getClusterId();
        String clusterIdInPayload = CartridgeAgentConfiguration.getInstance().getClusterId();
        String repoURL = artifactUpdatedEvent.getRepoURL();
        if (StringUtils.isNotEmpty((CharSequence)repoURL) && clusterIdInPayload != null && clusterIdInPayload.equals(clusterIdInMessage)) {
            boolean artifactUpdateEnabled;
            String localRepoPath = CartridgeAgentConfiguration.getInstance().getAppPath();
            String repoPassword = CartridgeAgentUtils.decryptPassword(artifactUpdatedEvent.getRepoPassword());
            String repoUsername = artifactUpdatedEvent.getRepoUserName();
            String tenantId = artifactUpdatedEvent.getTenantId();
            boolean isMultitenant = CartridgeAgentConfiguration.getInstance().isMultitenant();
            if (log.isInfoEnabled()) {
                log.info((Object)"Executing git checkout");
            }
            RepositoryInformation repoInformation = new RepositoryInformation();
            repoInformation.setRepoUsername(repoUsername);
            if (repoPassword == null) {
                repoInformation.setRepoPassword("");
            } else {
                repoInformation.setRepoPassword(repoPassword);
            }
            repoInformation.setRepoUrl(repoURL);
            repoInformation.setRepoPath(localRepoPath);
            repoInformation.setTenantId(tenantId);
            repoInformation.setMultitenant(isMultitenant);
            boolean cloneExists = GitBasedArtifactRepository.getInstance().cloneExists(repoInformation);
            try {
                GitBasedArtifactRepository.getInstance().checkout(repoInformation);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("STRATOS_ARTIFACT_UPDATED_CLUSTER_ID", artifactUpdatedEvent.getClusterId());
            env.put("STRATOS_ARTIFACT_UPDATED_TENANT_ID", artifactUpdatedEvent.getTenantId());
            env.put("STRATOS_ARTIFACT_UPDATED_REPO_URL", artifactUpdatedEvent.getRepoURL());
            env.put("STRATOS_ARTIFACT_UPDATED_REPO_PASSWORD", artifactUpdatedEvent.getRepoPassword());
            env.put("STRATOS_ARTIFACT_UPDATED_REPO_USERNAME", artifactUpdatedEvent.getRepoUserName());
            env.put("STRATOS_ARTIFACT_UPDATED_STATUS", artifactUpdatedEvent.getStatus());
            ExtensionUtils.executeArtifactsUpdatedExtension(env);
            if (!cloneExists && !isMultitenant) {
                CartridgeAgentEventPublisher.publishInstanceActivatedEvent();
                ExtensionUtils.executeInstanceActivatedExtension();
            }
            if (artifactUpdateEnabled = Boolean.parseBoolean(System.getProperty("enable.artifact.update"))) {
                boolean autoCommit = CartridgeAgentConfiguration.getInstance().isCommitsEnabled();
                boolean autoCheckout = CartridgeAgentConfiguration.getInstance().isCheckoutEnabled();
                long artifactUpdateInterval = 10L;
                String artifactUpdateIntervalStr = System.getProperty("artifact.update.interval");
                if (artifactUpdateIntervalStr != null && !artifactUpdateIntervalStr.isEmpty()) {
                    try {
                        artifactUpdateInterval = Long.parseLong(artifactUpdateIntervalStr);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)"Invalid artifact sync interval specified ", (Throwable)e);
                        artifactUpdateInterval = 10L;
                    }
                }
                log.info((Object)("Artifact updating task enabled, update interval: " + artifactUpdateInterval + "s"));
                if (autoCommit) {
                    log.info((Object)"Auto Commit is turned on ");
                } else {
                    log.info((Object)"Auto Commit is turned off ");
                }
                if (autoCheckout) {
                    log.info((Object)"Auto Checkout is turned on ");
                } else {
                    log.info((Object)"Auto Checkout is turned off ");
                }
                GitBasedArtifactRepository.getInstance().scheduleSyncTask(repoInformation, autoCheckout, autoCommit, artifactUpdateInterval);
            } else {
                log.info((Object)"Artifact updating task disabled");
            }
        }
    }

    @Override
    public void onArtifactUpdateSchedulerEvent(String tenantId) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("STRATOS_ARTIFACT_UPDATED_TENANT_ID", tenantId);
        env.put("STRATOS_ARTIFACT_UPDATED_SCHEDULER", "true");
        ExtensionUtils.executeArtifactsUpdatedExtension(env);
    }

    @Override
    public void onInstanceCleanupClusterEvent(InstanceCleanupClusterEvent instanceCleanupClusterEvent) {
        this.cleanup();
    }

    @Override
    public void onInstanceCleanupMemberEvent(InstanceCleanupMemberEvent instanceCleanupMemberEvent) {
        this.cleanup();
    }

    private void cleanup() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Executing cleaning up the data in the cartridge instance...");
        }
        CartridgeAgentEventPublisher.publishMaintenanceModeEvent();
        ExtensionUtils.executeCleanupExtension();
        if (log.isInfoEnabled()) {
            log.info((Object)"cleaning up finished in the cartridge instance...");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"publishing ready to shutdown event...");
        }
        CartridgeAgentEventPublisher.publishInstanceReadyToShutdownEvent();
    }

    @Override
    public void onMemberActivatedEvent(MemberActivatedEvent memberActivatedEvent) {
        boolean memberInitialized;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Member activated event received: [service] %s [cluster] %s [member] %s", memberActivatedEvent.getServiceName(), memberActivatedEvent.getClusterId(), memberActivatedEvent.getMemberId()));
        }
        if (log.isDebugEnabled()) {
            String msg = gson.toJson((Object)memberActivatedEvent);
            log.debug((Object)("Member activated event msg:" + msg));
        }
        if (!(memberInitialized = ExtensionUtils.checkTopologyConsistency(memberActivatedEvent.getServiceName(), memberActivatedEvent.getClusterId(), memberActivatedEvent.getMemberId()))) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Member has not initialized. Failed to execute member activated event");
            }
            return;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        ExtensionUtils.executeMemberActivatedExtension(env);
    }

    @Override
    public void onCompleteTopologyEvent(CompleteTopologyEvent completeTopologyEvent) {
        String memberIdInPayload;
        String clusterIdInPayload;
        String serviceNameInPayload;
        boolean isConsistent;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Complete topology event received");
        }
        if (!(isConsistent = ExtensionUtils.checkTopologyConsistency(serviceNameInPayload = CartridgeAgentConfiguration.getInstance().getServiceName(), clusterIdInPayload = CartridgeAgentConfiguration.getInstance().getClusterId(), memberIdInPayload = CartridgeAgentConfiguration.getInstance().getMemberId()))) {
            return;
        }
        CartridgeAgentConfiguration.getInstance().setInitialized(true);
        Topology topology = completeTopologyEvent.getTopology();
        Service service = topology.getService(serviceNameInPayload);
        Cluster cluster = service.getCluster(clusterIdInPayload);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("STRATOS_TOPOLOGY_JSON", gson.toJson((Object)topology.getServices(), serviceType));
        env.put("STRATOS_MEMBER_LIST_JSON", gson.toJson((Object)cluster.getMembers(), memberType));
        ExtensionUtils.executeCompleteTopologyExtension(env);
    }

    @Override
    public void onMemberInitializedEvent(MemberInitializedEvent memberInitializedEvent) {
        String memberIdInPayload;
        String clusterIdInPayload;
        String serviceNameInPayload;
        Member activatedMember;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Member initialized event received");
        }
        if ((activatedMember = ExtensionUtils.getMemberFromTopology(serviceNameInPayload = CartridgeAgentConfiguration.getInstance().getServiceName(), clusterIdInPayload = CartridgeAgentConfiguration.getInstance().getClusterId(), memberIdInPayload = CartridgeAgentConfiguration.getInstance().getMemberId())) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Member does not exist in topology, or not in initialized state.");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Member has initialized, topology is consistent, agent is initialized");
            }
            CartridgeAgentConfiguration.getInstance().setInitialized(true);
        }
    }

    @Override
    public void onMemberCreatedEvent(MemberCreatedEvent memberCreatedEvent) {
        String memberIdInPayload;
        String clusterIdInPayload;
        String serviceNameInPayload;
        boolean memberInitialized;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Instance Spawned event received");
        }
        if (memberInitialized = ExtensionUtils.checkTopologyConsistency(serviceNameInPayload = CartridgeAgentConfiguration.getInstance().getServiceName(), clusterIdInPayload = CartridgeAgentConfiguration.getInstance().getClusterId(), memberIdInPayload = CartridgeAgentConfiguration.getInstance().getMemberId())) {
            CartridgeAgentConfiguration.getInstance().setInitialized(true);
        }
    }

    @Override
    public void onCompleteTenantEvent(CompleteTenantEvent completeTenantEvent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Complete tenant event received");
        }
        String tenantListJson = gson.toJson((Object)completeTenantEvent.getTenants(), tenantType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Complete tenants:" + tenantListJson));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("STRATOS_TENANT_LIST_JSON", tenantListJson);
        ExtensionUtils.executeCompleteTenantExtension(env);
    }

    @Override
    public void onMemberTerminatedEvent(MemberTerminatedEvent memberTerminatedEvent) {
        boolean memberInitialized;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Member terminated event received: [service] %s [cluster] %s [member] %s", memberTerminatedEvent.getServiceName(), memberTerminatedEvent.getClusterId(), memberTerminatedEvent.getMemberId()));
        }
        if (log.isDebugEnabled()) {
            String msg = gson.toJson((Object)memberTerminatedEvent);
            log.debug((Object)("Member terminated event msg:" + msg));
        }
        if (!(memberInitialized = ExtensionUtils.checkTopologyConsistency(memberTerminatedEvent.getServiceName(), memberTerminatedEvent.getClusterId(), memberTerminatedEvent.getMemberId()))) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Member has not initialized. Failed to execute member terminated event");
            }
            return;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        ExtensionUtils.executeMemberTerminatedExtension(env);
    }

    @Override
    public void onMemberSuspendedEvent(MemberSuspendedEvent memberSuspendedEvent) {
        boolean memberInitialized;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Member suspended event received: [service] %s [cluster] %s [member] %s", memberSuspendedEvent.getServiceName(), memberSuspendedEvent.getClusterId(), memberSuspendedEvent.getMemberId()));
        }
        if (log.isDebugEnabled()) {
            String msg = gson.toJson((Object)memberSuspendedEvent);
            log.debug((Object)("Member suspended event msg:" + msg));
        }
        if (!(memberInitialized = ExtensionUtils.checkTopologyConsistency(memberSuspendedEvent.getServiceName(), memberSuspendedEvent.getClusterId(), memberSuspendedEvent.getMemberId()))) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Member has not initialized. Failed to execute member suspended event");
            }
            return;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        ExtensionUtils.executeMemberSuspendedExtension(env);
    }

    @Override
    public void onMemberStartedEvent(MemberStartedEvent memberStartedEvent) {
        boolean memberInitialized;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Member started event received: [service] %s [cluster] %s [member] %s", memberStartedEvent.getServiceName(), memberStartedEvent.getClusterId(), memberStartedEvent.getMemberId()));
        }
        if (log.isDebugEnabled()) {
            String msg = gson.toJson((Object)memberStartedEvent);
            log.debug((Object)("Member started event msg:" + msg));
        }
        if (!(memberInitialized = ExtensionUtils.checkTopologyConsistency(memberStartedEvent.getServiceName(), memberStartedEvent.getClusterId(), memberStartedEvent.getMemberId()))) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Member has not initialized. Failed to execute member started event");
            }
            return;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        ExtensionUtils.executeMemberStartedExtension(env);
    }

    @Override
    public void startServerExtension() {
        String memberIdInPayload;
        String clusterIdInPayload;
        String serviceNameInPayload;
        boolean isConsistent;
        ExtensionUtils.waitForCompleteTopology();
        if (log.isInfoEnabled()) {
            log.info((Object)"[start server extension] complete topology event received");
        }
        if (!(isConsistent = ExtensionUtils.checkTopologyConsistency(serviceNameInPayload = CartridgeAgentConfiguration.getInstance().getServiceName(), clusterIdInPayload = CartridgeAgentConfiguration.getInstance().getClusterId(), memberIdInPayload = CartridgeAgentConfiguration.getInstance().getMemberId()))) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Topology is inconsistent...Failed to execute start server event");
            }
            return;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        ExtensionUtils.executeStartServersExtension(env);
    }

    @Override
    public void volumeMountExtension(String persistenceMappingsPayload) {
        ExtensionUtils.executeVolumeMountExtension(persistenceMappingsPayload);
    }

    @Override
    public void onDomainMappingAddedEvent(DomainMappingAddedEvent domainMappingAddedEvent) {
        String tenantDomain = this.findTenantDomain(domainMappingAddedEvent.getTenantId());
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Domain mapping added event received: [tenant-id] %d [tenant-domain] %s [domain-name] %s [application-context] %s", domainMappingAddedEvent.getTenantId(), tenantDomain, domainMappingAddedEvent.getDomainName(), domainMappingAddedEvent.getContextPath()));
        }
        if (log.isDebugEnabled()) {
            String msg = gson.toJson((Object)domainMappingAddedEvent);
            log.debug((Object)("Domain mapping added event msg:" + msg));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("STRATOS_SUBSCRIPTION_APPLICATION_ID", domainMappingAddedEvent.getApplicationId());
        env.put("STRATOS_SUBSCRIPTION_SERVICE_NAME", domainMappingAddedEvent.getServiceName());
        env.put("STRATOS_SUBSCRIPTION_DOMAIN_NAME", domainMappingAddedEvent.getDomainName());
        env.put("STRATOS_SUBSCRIPTION_CLUSTER_ID", domainMappingAddedEvent.getClusterId());
        env.put("STRATOS_SUBSCRIPTION_TENANT_ID", Integer.toString(domainMappingAddedEvent.getTenantId()));
        env.put("STRATOS_SUBSCRIPTION_TENANT_DOMAIN", tenantDomain);
        env.put("STRATOS_SUBSCRIPTION_CONTEXT_PATH", domainMappingAddedEvent.getContextPath());
        ExtensionUtils.executeDomainMappingAddedExtension(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findTenantDomain(int tenantId) {
        try {
            TenantManager.acquireReadLock();
            Tenant tenant = TenantManager.getInstance().getTenant(tenantId);
            if (tenant == null) {
                throw new RuntimeException(String.format("Tenant could not be found: [tenant-id] %d", tenantId));
            }
            String string = tenant.getTenantDomain();
            return string;
        }
        finally {
            TenantManager.releaseReadLock();
        }
    }

    @Override
    public void onDomainMappingRemovedEvent(DomainMappingRemovedEvent subscriptionDomainRemovedEvent) {
        String tenantDomain = this.findTenantDomain(subscriptionDomainRemovedEvent.getTenantId());
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Domain mapping removed event received: [tenant-id] %d [tenant-domain] %s [domain-name] %s", subscriptionDomainRemovedEvent.getTenantId(), tenantDomain, subscriptionDomainRemovedEvent.getDomainName()));
        }
        if (log.isDebugEnabled()) {
            String msg = gson.toJson((Object)subscriptionDomainRemovedEvent);
            log.debug((Object)("Domain mapping removed event msg:" + msg));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("STRATOS_SUBSCRIPTION_APPLICATION_ID", subscriptionDomainRemovedEvent.getApplicationId());
        env.put("STRATOS_SUBSCRIPTION_SERVICE_NAME", subscriptionDomainRemovedEvent.getServiceName());
        env.put("STRATOS_SUBSCRIPTION_DOMAIN_NAME", subscriptionDomainRemovedEvent.getDomainName());
        env.put("STRATOS_SUBSCRIPTION_CLUSTER_ID", subscriptionDomainRemovedEvent.getClusterId());
        env.put("STRATOS_SUBSCRIPTION_TENANT_ID", Integer.toString(subscriptionDomainRemovedEvent.getTenantId()));
        env.put("STRATOS_SUBSCRIPTION_TENANT_DOMAIN", tenantDomain);
        ExtensionUtils.executeDomainMappingRemovedExtension(env);
    }

    @Override
    public void onCopyArtifactsExtension(String src, String des) {
        ExtensionUtils.executeCopyArtifactsExtension(src, des);
    }

    @Override
    public void onTenantSubscribedEvent(TenantSubscribedEvent tenantSubscribedEvent) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Tenant subscribed event received: [tenant] %s [service] %s [cluster] %s", tenantSubscribedEvent.getTenantId(), tenantSubscribedEvent.getServiceName(), tenantSubscribedEvent.getClusterIds()));
        }
        if (log.isDebugEnabled()) {
            String msg = gson.toJson((Object)tenantSubscribedEvent);
            log.debug((Object)("Tenant subscribed event msg:" + msg));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        ExtensionUtils.executeTenantSubscribedExtension(env);
    }

    @Override
    public void onTenantUnSubscribedEvent(TenantUnSubscribedEvent tenantUnSubscribedEvent) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Tenant unsubscribed event received: [tenant] %s [service] %s [cluster] %s", tenantUnSubscribedEvent.getTenantId(), tenantUnSubscribedEvent.getServiceName(), tenantUnSubscribedEvent.getClusterIds()));
        }
        if (log.isDebugEnabled()) {
            String msg = gson.toJson((Object)tenantUnSubscribedEvent);
            log.debug((Object)("Tenant unsubscribed event msg:" + msg));
        }
        try {
            if (CartridgeAgentConfiguration.getInstance().getServiceName().equals(tenantUnSubscribedEvent.getServiceName())) {
                GitBasedArtifactRepository.getInstance().removeRepo(tenantUnSubscribedEvent.getTenantId());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        ExtensionUtils.executeTenantUnSubscribedExtension(env);
    }

    @Override
    public void onApplicationSignUpRemovedEvent(ApplicationSignUpRemovedEvent applicationSignUpRemovedEvent) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("applicationSignUpRemovedEvent event received: [appId] %s [tenantId] %s ", applicationSignUpRemovedEvent.getApplicationId(), applicationSignUpRemovedEvent.getTenantId()));
        }
        try {
            if (CartridgeAgentConfiguration.getInstance().getApplicationId().equals(applicationSignUpRemovedEvent.getApplicationId())) {
                GitBasedArtifactRepository.getInstance().removeRepo(applicationSignUpRemovedEvent.getTenantId());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

