/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.statistics.publisher;

import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.statistics.publisher.CartridgeStatistics;
import org.apache.stratos.cartridge.agent.statistics.publisher.HealthStatisticsReader;
import org.apache.stratos.cartridge.agent.statistics.publisher.IHealthStatisticsReader;
import org.apache.stratos.cartridge.agent.statistics.publisher.PluginLoader;
import org.apache.stratos.common.statistics.publisher.HealthStatisticsPublisher;
import org.apache.stratos.common.statistics.publisher.HealthStatisticsPublisherFactory;
import org.apache.stratos.common.statistics.publisher.StatisticsPublisherType;

public class HealthStatisticsNotifier
implements Runnable {
    private static final Log log = LogFactory.getLog(HealthStatisticsNotifier.class);
    private final HealthStatisticsPublisher statsPublisher = HealthStatisticsPublisherFactory.createHealthStatisticsPublisher((StatisticsPublisherType)StatisticsPublisherType.WSO2CEP);
    private IHealthStatisticsReader statsReader;
    private long statsPublisherInterval = 15000L;
    private boolean terminated;

    public HealthStatisticsNotifier() {
        String interval;
        String pluginFileName = System.getProperty("health.stats.reader.plugin");
        if (pluginFileName != null && pluginFileName.length() != 0) {
            File pluginFile = new File(pluginFileName);
            if (pluginFile != null && pluginFile.exists()) {
                List<Class> pluginClass = PluginLoader.loadPluginClassesFromJar(pluginFile, IHealthStatisticsReader.class);
                if (!pluginClass.isEmpty()) {
                    try {
                        log.trace((Object)("Instantiating new instance of plugin type " + pluginClass));
                        this.statsReader = (IHealthStatisticsReader)pluginClass.get(0).newInstance();
                    }
                    catch (InstantiationException e) {
                        log.error((Object)("Unable to instantiate plugin " + pluginClass), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)("Unable to instantiate plugin " + pluginClass), (Throwable)e);
                    }
                }
            } else {
                log.error((Object)("Plugin not found or malformed: " + pluginFileName + (pluginFile == null ? " NULL" : "Doesn't exist")));
            }
        }
        if (this.statsReader == null) {
            this.statsReader = new HealthStatisticsReader();
        }
        if ((interval = System.getProperty("stats.notifier.interval")) != null) {
            this.statsPublisherInterval = Long.getLong(interval);
        }
    }

    @Override
    public void run() {
        if (!this.statsReader.init()) {
            log.error((Object)("Health statistics reader " + this.statsReader.getClass().getName() + " could not initialise"));
        } else {
            while (!this.terminated) {
                try {
                    try {
                        Thread.sleep(this.statsPublisherInterval);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (this.statsPublisher.isEnabled()) {
                        CartridgeStatistics stats = this.statsReader.getCartridgeStatistics();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Publishing memory consumption: %f", stats.getMemoryUsage()));
                        }
                        this.statsPublisher.publish(CartridgeAgentConfiguration.getInstance().getClusterId(), CartridgeAgentConfiguration.getInstance().getClusterInstanceId(), CartridgeAgentConfiguration.getInstance().getNetworkPartitionId(), CartridgeAgentConfiguration.getInstance().getMemberId(), CartridgeAgentConfiguration.getInstance().getPartitionId(), "memory_consumption", stats.getMemoryUsage());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Publishing load average: %f", stats.getProcessorUsage()));
                        }
                        this.statsPublisher.publish(CartridgeAgentConfiguration.getInstance().getClusterId(), CartridgeAgentConfiguration.getInstance().getClusterInstanceId(), CartridgeAgentConfiguration.getInstance().getNetworkPartitionId(), CartridgeAgentConfiguration.getInstance().getMemberId(), CartridgeAgentConfiguration.getInstance().getPartitionId(), "load_average", stats.getProcessorUsage());
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Statistics publisher is disabled");
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Could not publish health statistics", (Throwable)e);
                }
            }
            this.statsReader.delete();
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

