/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.statistics.publisher;

import com.sun.management.OperatingSystemMXBean;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.statistics.publisher.CartridgeStatistics;
import org.apache.stratos.cartridge.agent.statistics.publisher.IHealthStatisticsReader;
import org.apache.stratos.cartridge.agent.util.CartridgeAgentUtils;

public class HealthStatisticsReader
implements IHealthStatisticsReader {
    private static final int MB = 0x100000;
    private static final Log log = LogFactory.getLog(HealthStatisticsReader.class);

    @Override
    public boolean init() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getMemoryConsumption() {
        double totalMemory = 0.0;
        double usedMemory = 0.0;
        if (HealthStatisticsReader.isWindows()) {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            totalMemory = osBean.getTotalPhysicalMemorySize() / 0x100000L;
            usedMemory = totalMemory - (double)(osBean.getFreePhysicalMemorySize() / 0x100000L);
        } else {
            String fName = "/proc/meminfo";
            try {
                FileInputStream f = new FileInputStream(fName);
                Scanner scanner = new Scanner(f).useDelimiter("\\D+");
                try {
                    long memTotal = scanner.nextLong();
                    long memFree = scanner.nextLong();
                    long buffers = scanner.nextLong();
                    long cached = scanner.nextLong();
                    totalMemory = memTotal;
                    usedMemory = memTotal - (memFree + buffers + cached);
                }
                catch (Exception ex) {
                    log.error((Object)"Could not calculate memory usage.", (Throwable)ex);
                }
                finally {
                    scanner.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)"Could not calculate memory usage.", (Throwable)ex);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculating memory consumption: [totalMemory] " + totalMemory + " [usedMemory] " + usedMemory));
        }
        double memoryConsumption = usedMemory / totalMemory * 100.0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculating memory consumption: [percentage] " + memoryConsumption));
        }
        return memoryConsumption;
    }

    public static double getLoadAverage() {
        double loadAvg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        int cores = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculating load average consumption: [loadAverage] " + loadAvg + " [cores] " + cores));
        }
        double loadAvgPercentage = loadAvg / (double)cores * 100.0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculating load average consumption: [percentage] " + loadAvgPercentage));
        }
        return loadAvgPercentage;
    }

    @Override
    public CartridgeStatistics getCartridgeStatistics() throws IOException {
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double totalMemory = osBean.getTotalPhysicalMemorySize() / 0x100000L;
        double usedMemory = totalMemory - (double)(osBean.getFreePhysicalMemorySize() / 0x100000L);
        double loadAvg = osBean.getSystemLoadAverage();
        int cores = osBean.getAvailableProcessors();
        double memoryConsumption = usedMemory / totalMemory * 100.0;
        double loadAvgPercentage = loadAvg / (double)cores * 100.0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Memory consumption: [totalMemory] " + totalMemory + "Mb [usedMemory] " + usedMemory + "Mb: " + memoryConsumption + "%"));
            log.debug((Object)("Processor consumption: [loadAverage] " + loadAvg + " [cores] " + cores + ": " + loadAvgPercentage + "%"));
        }
        return new CartridgeStatistics(memoryConsumption, loadAvgPercentage);
    }

    public static boolean allPortsActive() {
        return CartridgeAgentUtils.checkPortsActive(CartridgeAgentConfiguration.getInstance().getListenAddress(), CartridgeAgentConfiguration.getInstance().getPorts());
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    @Override
    public void delete() {
    }
}

