/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.statistics.publisher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginLoader {
    private static final Log log = LogFactory.getLog(PluginLoader.class);

    public static List<Class> loadPluginClassesFromJar(File jarPath, Class pluginInterface) {
        LinkedList<Class> listeners = new LinkedList<Class>();
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{jarPath.toURI().toURL()});
            JarFile jar = new JarFile(jarPath);
            Enumeration<JarEntry> jarEnum = jar.entries();
            log.trace((Object)("Scanning jar file " + jarPath));
            while (jarEnum.hasMoreElements()) {
                ZipEntry zipEntry = jarEnum.nextElement();
                String fileName = zipEntry.getName();
                if (!fileName.endsWith(".class")) continue;
                log.trace((Object)("Considering jar entry " + fileName));
                try {
                    String className = fileName.replace(".class", "").replace("/", ".");
                    Class<?> cls = loader.loadClass(className);
                    log.trace((Object)("Loaded class " + className));
                    if (!PluginLoader.hasInterface(cls, pluginInterface)) continue;
                    log.trace((Object)("Class has " + pluginInterface.getName() + " interface; adding "));
                    listeners.add(cls);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Unable to load class from " + fileName + " in " + jarPath));
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("Unable to open JAR file " + jarPath), (Throwable)e);
        }
        return listeners;
    }

    private static boolean hasInterface(Class cls, Class iface) {
        for (Class<?> in : cls.getInterfaces()) {
            if (in != iface) continue;
            return true;
        }
        return false;
    }
}

