/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.common.util.CommandUtils;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

public class ExtensionUtils {
    private static final Log log = LogFactory.getLog(ExtensionUtils.class);

    private static String getExtensionsDir() {
        String extensionsDir = System.getProperty("extensions.dir");
        if (StringUtils.isBlank((CharSequence)extensionsDir)) {
            throw new RuntimeException(String.format("System property not found: %s", "extensions.dir"));
        }
        return extensionsDir;
    }

    private static String prepareCommand(String scriptFile) throws FileNotFoundException {
        String extensionsDir = ExtensionUtils.getExtensionsDir();
        String filePath = extensionsDir.endsWith(File.separator) ? extensionsDir + scriptFile : extensionsDir + File.separator + scriptFile;
        File file = new File(filePath);
        if (file.exists() && !file.isDirectory()) {
            return filePath;
        }
        throw new FileNotFoundException("Script file not found:" + filePath);
    }

    public static void addPayloadParameters(Map<String, String> envParameters) {
        String lbPublicIp;
        String lbIp;
        envParameters.put("STRATOS_APP_PATH", CartridgeAgentConfiguration.getInstance().getAppPath());
        envParameters.put("STRATOS_PARAM_FILE_PATH", System.getProperty("param.file.path"));
        envParameters.put("STRATOS_SERVICE_NAME", CartridgeAgentConfiguration.getInstance().getServiceName());
        envParameters.put("STRATOS_TENANT_ID", CartridgeAgentConfiguration.getInstance().getTenantId());
        envParameters.put("STRATOS_CARTRIDGE_KEY", CartridgeAgentConfiguration.getInstance().getCartridgeKey());
        envParameters.put("STRATOS_LB_CLUSTER_ID", CartridgeAgentConfiguration.getInstance().getLbClusterId());
        envParameters.put("STRATOS_CLUSTER_ID", CartridgeAgentConfiguration.getInstance().getClusterId());
        envParameters.put("STRATOS_NETWORK_PARTITION_ID", CartridgeAgentConfiguration.getInstance().getNetworkPartitionId());
        envParameters.put("STRATOS_PARTITION_ID", CartridgeAgentConfiguration.getInstance().getPartitionId());
        envParameters.put("STRATOS_PERSISTENCE_MAPPINGS", CartridgeAgentConfiguration.getInstance().getPersistenceMappings());
        envParameters.put("STRATOS_REPO_URL", CartridgeAgentConfiguration.getInstance().getRepoUrl());
        String lbClusterIdInPayload = CartridgeAgentConfiguration.getInstance().getLbClusterId();
        String[] memberIps = ExtensionUtils.getLbMemberIp(lbClusterIdInPayload);
        if (memberIps != null && memberIps.length > 1) {
            lbIp = memberIps[0];
            lbPublicIp = memberIps[1];
        } else {
            lbIp = CartridgeAgentConfiguration.getInstance().getLbPrivateIp();
            lbPublicIp = CartridgeAgentConfiguration.getInstance().getLbPublicIp();
        }
        envParameters.put("STRATOS_LB_IP", lbIp);
        envParameters.put("STRATOS_LB_PUBLIC_IP", lbPublicIp);
        Topology topology = TopologyManager.getTopology();
        if (topology.isInitialized()) {
            Service service = topology.getService(CartridgeAgentConfiguration.getInstance().getServiceName());
            Cluster cluster = service.getCluster(CartridgeAgentConfiguration.getInstance().getClusterId());
            String memberIdInPayload = CartridgeAgentConfiguration.getInstance().getMemberId();
            ExtensionUtils.addProperties(service.getProperties(), envParameters, "SERVICE_PROPERTY");
            ExtensionUtils.addProperties(cluster.getProperties(), envParameters, "CLUSTER_PROPERTY");
            ExtensionUtils.addProperties(cluster.getMember(memberIdInPayload).getProperties(), envParameters, "MEMBER_PROPERTY");
        }
    }

    public static void addProperties(Properties properties, Map<String, String> envParameters, String prefix) {
        if (properties == null || properties.entrySet() == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            envParameters.put("STRATOS_ " + prefix + "_" + entry.getKey().toString(), entry.getValue().toString());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("Property added: [key] %s [value] %s", "STRATOS_ " + prefix + "_" + entry.getKey().toString(), entry.getValue().toString()));
        }
    }

    public static String[] getLbMemberIp(String lbClusterId) {
        Topology topology = TopologyManager.getTopology();
        Collection serviceCollection = topology.getServices();
        for (Service service : serviceCollection) {
            Collection clusterCollection = service.getClusters();
            for (Cluster cluster : clusterCollection) {
                Collection memberCollection = cluster.getMembers();
                for (Member member : memberCollection) {
                    if (!member.getClusterId().equals(lbClusterId)) continue;
                    return new String[]{member.getDefaultPrivateIP(), member.getDefaultPublicIP()};
                }
            }
        }
        return null;
    }

    private static Map<String, String> cleanProcessParameters(Map<String, String> envParameters) {
        Iterator<Map.Entry<String, String>> iter = envParameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (entry.getValue() != null) continue;
            iter.remove();
        }
        return envParameters;
    }

    public static void executeStartServersExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing start servers extension");
                }
                String script = System.getProperty("extension.start.servers");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start server script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute start servers extension", (Throwable)e);
            }
        }
    }

    public static void executeCleanupExtension() {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing cleanup extension");
                }
                String script = System.getProperty("extension.clean");
                String command = ExtensionUtils.prepareCommand(script);
                String output = CommandUtils.executeCommand((String)command);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cleanup script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute cleanup extension", (Throwable)e);
            }
        }
    }

    public static void executeInstanceStartedExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing instance started extension");
                }
                String script = System.getProperty("extension.instance.started");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Instance started script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute instance started extension", (Throwable)e);
            }
        }
    }

    public static void executeInstanceActivatedExtension() {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing instance activated extension");
                }
                String script = System.getProperty("extension.instance.activated");
                String command = ExtensionUtils.prepareCommand(script);
                String output = CommandUtils.executeCommand((String)command);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Instance activated script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute instance activated extension", (Throwable)e);
            }
        }
    }

    public static void executeArtifactsUpdatedExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing artifacts updated extension");
                }
                String script = System.getProperty("extension.artifacts.updated");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Artifacts updated script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute artifacts updated extension", (Throwable)e);
            }
        }
    }

    public static void executeCopyArtifactsExtension(String source, String destination) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing artifacts copy extension");
            }
            String command = ExtensionUtils.prepareCommand(System.getProperty("extension.artifacts.copy"));
            CommandUtils.executeCommand((String)(command + " " + source + " " + destination));
        }
        catch (Exception e) {
            log.error((Object)"Could not execute artifacts copy extension", (Throwable)e);
        }
    }

    public static void executeVolumeMountExtension(String persistenceMappingsPayload) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Executing volume mounting extension: [payload] %s", persistenceMappingsPayload));
                }
                String script = System.getProperty("extension.mount.volumes");
                String command = ExtensionUtils.prepareCommand(script);
                String output = CommandUtils.executeCommand((String)(command + " " + persistenceMappingsPayload));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Volume mount script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute volume mounting extension", (Throwable)e);
            }
        }
    }

    public static void executeMemberActivatedExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing member activated extension");
                }
                String script = System.getProperty("extension.member.activated");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Member activated script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute member activated extension", (Throwable)e);
            }
        }
    }

    public static void executeMemberTerminatedExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing member terminated extension");
                }
                String script = System.getProperty("extension.member.terminated");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Member terminated script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute member terminated extension", (Throwable)e);
            }
        }
    }

    public static void executeMemberStartedExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing member started extension");
                }
                String script = System.getProperty("extension.member.started");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Member started script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute member started extension", (Throwable)e);
            }
        }
    }

    public static void executeMemberSuspendedExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing member suspended extension");
                }
                String script = System.getProperty("extension.member.suspended");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Member suspended script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute member suspended extension", (Throwable)e);
            }
        }
    }

    public static void executeCompleteTopologyExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing complete topology extension");
                }
                String script = System.getProperty("extension.complete.topology");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Complete topology script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute complete topology extension", (Throwable)e);
            }
        }
    }

    public static void executeCompleteTenantExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing complete tenant extension");
                }
                String script = System.getProperty("extension.complete.tenant");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Complete tenant script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute complete tenant extension", (Throwable)e);
            }
        }
    }

    public static void executeDomainMappingAddedExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing domain mapping added extension");
                }
                String script = System.getProperty("extension.domain.mapping.added");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Domain mapping added script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute domain mapping added extension", (Throwable)e);
            }
        }
    }

    public static void executeDomainMappingRemovedExtension(Map<String, String> envParameters) {
        block4: {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing domain mapping removed extension");
                }
                String script = System.getProperty("extension.domain.mapping.removed");
                String command = ExtensionUtils.prepareCommand(script);
                ExtensionUtils.addPayloadParameters(envParameters);
                ExtensionUtils.cleanProcessParameters(envParameters);
                String output = CommandUtils.executeCommand((String)command, envParameters);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Domain mapping removed script returned:" + output));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not execute domain mapping removed extension", (Throwable)e);
            }
        }
    }

    public static void executeTenantSubscribedExtension(Map<String, String> envParameters) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing tenant subscribed extension");
            }
            String script = System.getProperty("extension.tenant.subscribed");
            String command = ExtensionUtils.prepareCommand(script);
            ExtensionUtils.addPayloadParameters(envParameters);
            ExtensionUtils.cleanProcessParameters(envParameters);
            CommandUtils.executeCommand((String)command, envParameters);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute tenant subscribed extension", (Throwable)e);
        }
    }

    public static void executeTenantUnSubscribedExtension(Map<String, String> envParameters) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing tenant un-subscribed extension");
            }
            String script = System.getProperty("extension.tenant.unsubscribed");
            String command = ExtensionUtils.prepareCommand(script);
            ExtensionUtils.addPayloadParameters(envParameters);
            ExtensionUtils.cleanProcessParameters(envParameters);
            CommandUtils.executeCommand((String)command, envParameters);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute tenant un-subscribed extension", (Throwable)e);
        }
    }

    public static boolean isTopologyInitialized() {
        TopologyManager.acquireReadLock();
        boolean active = TopologyManager.getTopology().isInitialized();
        TopologyManager.releaseReadLock();
        return active;
    }

    public static void waitForCompleteTopology() {
        while (!ExtensionUtils.isTopologyInitialized()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Waiting for complete topology event...");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean checkTopologyConsistency(String serviceName, String clusterId, String memberId) {
        Member activatedMember = ExtensionUtils.getMemberFromTopology(serviceName, clusterId, memberId);
        if (activatedMember == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("Member not found in topology [member] %s %s %s ", memberId, clusterId, serviceName));
            }
            return false;
        }
        return true;
    }

    public static Member getMemberFromTopology(String serviceName, String clusterId, String memberId) {
        Topology topology = TopologyManager.getTopology();
        Service service = topology.getService(serviceName);
        if (service == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("Service not found in topology [service] %s", serviceName));
            }
            return null;
        }
        Cluster cluster = service.getCluster(clusterId);
        if (cluster == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("Cluster id not found in topology [cluster] %s", clusterId));
            }
            return null;
        }
        Member activatedMember = cluster.getMember(memberId);
        if (activatedMember == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("Member id not found in topology [member] %s", memberId));
            }
            return null;
        }
        return activatedMember;
    }
}

