/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cep.extension;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cep.extension.FaultHandlingWindowProcessor;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.topology.CompleteTopologyEvent;
import org.apache.stratos.messaging.event.topology.MemberActivatedEvent;
import org.apache.stratos.messaging.event.topology.MemberTerminatedEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.topology.CompleteTopologyEventListener;
import org.apache.stratos.messaging.listener.topology.MemberActivatedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberTerminatedEventListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

public class CEPTopologyEventReceiver
extends TopologyEventReceiver {
    private static final Log log = LogFactory.getLog(CEPTopologyEventReceiver.class);
    private FaultHandlingWindowProcessor faultHandler;

    public CEPTopologyEventReceiver(FaultHandlingWindowProcessor faultHandler) {
        this.faultHandler = faultHandler;
        this.addEventListeners();
    }

    public void execute() {
        super.execute();
        log.info((Object)"CEP topology event receiver thread started");
    }

    private void addEventListeners() {
        this.addEventListener((EventListener)new CompleteTopologyEventListener(){
            private boolean initialized;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                if (!this.initialized) {
                    try {
                        TopologyManager.acquireReadLock();
                        log.debug((Object)"Complete topology event received to fault handling window processor.");
                        CompleteTopologyEvent completeTopologyEvent = (CompleteTopologyEvent)event;
                        this.initialized = CEPTopologyEventReceiver.this.faultHandler.loadTimeStampMapFromTopology(completeTopologyEvent.getTopology());
                    }
                    catch (Exception e) {
                        log.error((Object)"Error loading member time stamp map from complete topology event.", (Throwable)e);
                    }
                    finally {
                        TopologyManager.releaseReadLock();
                    }
                }
            }
        });
        this.addEventListener((EventListener)new MemberTerminatedEventListener(){

            protected void onEvent(Event event) {
                MemberTerminatedEvent memberTerminatedEvent = (MemberTerminatedEvent)event;
                CEPTopologyEventReceiver.this.faultHandler.getMemberTimeStampMap().remove(memberTerminatedEvent.getMemberId());
                log.debug((Object)("Member was removed from the timestamp map: [member] " + memberTerminatedEvent.getMemberId()));
            }
        });
        this.addEventListener((EventListener)new MemberActivatedEventListener(){

            protected void onEvent(Event event) {
                MemberActivatedEvent memberActivatedEvent = (MemberActivatedEvent)event;
                CEPTopologyEventReceiver.this.faultHandler.getMemberTimeStampMap().putIfAbsent(memberActivatedEvent.getMemberId(), System.currentTimeMillis());
                log.debug((Object)("Member was added to the timestamp map: [member] " + memberActivatedEvent.getMemberId()));
            }
        });
    }
}

