/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cep.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiContext;
import org.wso2.siddhi.core.event.BundleEvent;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.StreamEvent;
import org.wso2.siddhi.core.event.in.InEvent;
import org.wso2.siddhi.core.event.in.InListEvent;
import org.wso2.siddhi.core.event.remove.RemoveEvent;
import org.wso2.siddhi.core.event.remove.RemoveListEvent;
import org.wso2.siddhi.core.persistence.ThreadBarrier;
import org.wso2.siddhi.core.query.QueryPostProcessingElement;
import org.wso2.siddhi.core.query.processor.window.RunnableWindowProcessor;
import org.wso2.siddhi.core.query.processor.window.WindowProcessor;
import org.wso2.siddhi.core.util.collection.queue.scheduler.ISchedulerSiddhiQueue;
import org.wso2.siddhi.core.util.collection.queue.scheduler.SchedulerElement;
import org.wso2.siddhi.core.util.collection.queue.scheduler.SchedulerSiddhiQueue;
import org.wso2.siddhi.core.util.collection.queue.scheduler.SchedulerSiddhiQueueGrid;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.constant.IntConstant;
import org.wso2.siddhi.query.api.expression.constant.LongConstant;
import org.wso2.siddhi.query.api.extension.annotation.SiddhiExtension;

@SiddhiExtension(namespace="stratos", function="gradient")
public class GradientFinderWindowProcessor
extends WindowProcessor
implements RunnableWindowProcessor {
    static final Logger log = Logger.getLogger(GradientFinderWindowProcessor.class);
    private ScheduledExecutorService eventRemoverScheduler;
    private ScheduledFuture<?> lastSchedule;
    private long timeToKeep;
    private int subjectedAttrIndex;
    private Attribute.Type subjectedAttrType;
    private List<InEvent> newEventList;
    private List<RemoveEvent> oldEventList;
    private ThreadBarrier threadBarrier;
    private ISchedulerSiddhiQueue<StreamEvent> window;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(InEvent event) {
        this.acquireLock();
        try {
            this.newEventList.add(event);
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(InListEvent listEvent) {
        this.acquireLock();
        try {
            System.out.println(listEvent);
            int size = listEvent.getActiveEvents();
            for (int i = 0; i < size; ++i) {
                this.newEventList.add((InEvent)listEvent.getEvent(i));
            }
        }
        finally {
            this.releaseLock();
        }
    }

    public Iterator<StreamEvent> iterator() {
        return this.window.iterator();
    }

    public Iterator<StreamEvent> iterator(String predicate) {
        if (this.siddhiContext.isDistributedProcessingEnabled()) {
            return ((SchedulerSiddhiQueueGrid)this.window).iterator(predicate);
        }
        return this.window.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.acquireLock();
        try {
            long scheduledTime = System.currentTimeMillis();
            try {
                this.oldEventList.clear();
                while (true) {
                    this.threadBarrier.pass();
                    RemoveEvent removeEvent = (RemoveEvent)this.window.poll();
                    if (removeEvent == null) {
                        long diff;
                        if (this.oldEventList.size() > 0) {
                            this.nextProcessor.process((BundleEvent)new RemoveListEvent(this.oldEventList.toArray(new RemoveEvent[this.oldEventList.size()])));
                            this.oldEventList.clear();
                        }
                        if (this.newEventList.size() > 0) {
                            InEvent[] gradientEvents;
                            InEvent[] inEvents;
                            for (InEvent inEvent : inEvents = this.newEventList.toArray(new InEvent[this.newEventList.size()])) {
                                this.window.put((Object)new RemoveEvent((Event)inEvent, -1L));
                            }
                            for (InEvent inEvent : gradientEvents = this.gradient(inEvents[0], inEvents[this.newEventList.size() - 1])) {
                                this.window.put((Object)new RemoveEvent((Event)inEvent, -1L));
                            }
                            this.nextProcessor.process((BundleEvent)new InListEvent(gradientEvents));
                            this.newEventList.clear();
                        }
                        if ((diff = this.timeToKeep - (System.currentTimeMillis() - scheduledTime)) > 0L) {
                            try {
                                if (this.lastSchedule != null) {
                                    this.lastSchedule.cancel(false);
                                }
                                this.lastSchedule = this.eventRemoverScheduler.schedule((Runnable)((Object)this), diff, TimeUnit.MILLISECONDS);
                            }
                            catch (RejectedExecutionException ex) {
                                log.warn((Object)("scheduling cannot be accepted for execution: elementID " + this.elementId));
                            }
                            break;
                        }
                        scheduledTime = System.currentTimeMillis();
                        continue;
                    }
                    this.oldEventList.add(new RemoveEvent((Event)removeEvent, System.currentTimeMillis()));
                }
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
            }
        }
        finally {
            this.releaseLock();
        }
    }

    private InEvent[] gradient(InEvent firstInEvent, InEvent lastInEvent) {
        double firstVal = 0.0;
        double lastVal = 0.0;
        if (Attribute.Type.DOUBLE.equals((Object)this.subjectedAttrType)) {
            firstVal = (Double)firstInEvent.getData()[this.subjectedAttrIndex];
            lastVal = (Double)lastInEvent.getData()[this.subjectedAttrIndex];
        } else if (Attribute.Type.INT.equals((Object)this.subjectedAttrType)) {
            firstVal = ((Integer)firstInEvent.getData()[this.subjectedAttrIndex]).intValue();
            lastVal = ((Integer)lastInEvent.getData()[this.subjectedAttrIndex]).intValue();
        } else if (Attribute.Type.LONG.equals((Object)this.subjectedAttrType)) {
            firstVal = ((Long)firstInEvent.getData()[this.subjectedAttrIndex]).longValue();
            lastVal = ((Long)lastInEvent.getData()[this.subjectedAttrIndex]).longValue();
        } else if (Attribute.Type.FLOAT.equals((Object)this.subjectedAttrType)) {
            firstVal = ((Float)firstInEvent.getData()[this.subjectedAttrIndex]).floatValue();
            lastVal = ((Float)lastInEvent.getData()[this.subjectedAttrIndex]).floatValue();
        }
        long t1 = firstInEvent.getTimeStamp();
        long t2 = lastInEvent.getTimeStamp();
        long millisecondsForASecond = 1000L;
        long tGap = t2 - t1 > millisecondsForASecond ? t2 - t1 : millisecondsForASecond;
        double gradient = 0.0;
        if (tGap > 0L) {
            gradient = (lastVal - firstVal) * (double)millisecondsForASecond / (double)tGap;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Gradient: " + gradient + " Last val: " + lastVal + " First val: " + firstVal + " Time Gap: " + tGap + " t1: " + t1 + " t2: " + t2 + " hash: " + ((Object)((Object)this)).hashCode()));
        }
        Object[] data = (Object[])firstInEvent.getData().clone();
        data[this.subjectedAttrIndex] = gradient;
        InEvent gradientEvent = new InEvent(firstInEvent.getStreamId(), (t1 + t2) / 2L, data);
        InEvent[] output = new InEvent[]{gradientEvent};
        return output;
    }

    protected Object[] currentState() {
        return new Object[]{this.window.currentState(), this.oldEventList, this.newEventList};
    }

    protected void restoreState(Object[] data) {
        this.window.restoreState(data);
        this.window.restoreState((Object[])data[0]);
        this.oldEventList = (ArrayList)data[1];
        this.newEventList = (ArrayList)data[2];
        this.window.reSchedule();
    }

    protected void init(Expression[] parameters, QueryPostProcessingElement nextProcessor, AbstractDefinition streamDefinition, String elementId, boolean async, SiddhiContext siddhiContext) {
        this.timeToKeep = parameters[0] instanceof IntConstant ? (long)((IntConstant)parameters[0]).getValue().intValue() : ((LongConstant)parameters[0]).getValue();
        String subjectedAttr = ((Variable)parameters[1]).getAttributeName();
        this.subjectedAttrIndex = streamDefinition.getAttributePosition(subjectedAttr);
        this.subjectedAttrType = streamDefinition.getAttributeType(subjectedAttr);
        this.oldEventList = new ArrayList<RemoveEvent>();
        this.newEventList = this.siddhiContext.isDistributedProcessingEnabled() ? this.siddhiContext.getHazelcastInstance().getList(elementId + "-newEventList") : new ArrayList<InEvent>();
        this.window = this.siddhiContext.isDistributedProcessingEnabled() ? new SchedulerSiddhiQueueGrid(elementId, (SchedulerElement)this, this.siddhiContext, this.async) : new SchedulerSiddhiQueue((SchedulerElement)this);
        this.window.schedule();
    }

    public void schedule() {
        if (this.lastSchedule != null) {
            this.lastSchedule.cancel(false);
        }
        this.lastSchedule = this.eventRemoverScheduler.schedule((Runnable)((Object)this), this.timeToKeep, TimeUnit.MILLISECONDS);
    }

    public void scheduleNow() {
        if (this.lastSchedule != null) {
            this.lastSchedule.cancel(false);
        }
        this.lastSchedule = this.eventRemoverScheduler.schedule((Runnable)((Object)this), 0L, TimeUnit.MILLISECONDS);
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.eventRemoverScheduler = scheduledExecutorService;
    }

    public void setThreadBarrier(ThreadBarrier threadBarrier) {
        this.threadBarrier = threadBarrier;
    }

    public void destroy() {
        this.oldEventList = null;
        this.newEventList = null;
        this.window = null;
    }
}

