/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import java.io.File;
import java.io.IOException;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.commons.lang3.StringUtils;
import org.apache.stratos.cli.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandLineApplication<T extends CommandContext> {
    private static final Logger log = LoggerFactory.getLogger(CommandLineApplication.class);
    protected ConsoleReader reader;
    protected FileHistory history;
    protected String username;

    public CommandLineApplication(String[] args) {
        if (args != null && args.length > 1) {
            this.username = args[1];
        }
        this.reader = this.createConsoleReader();
    }

    protected ConsoleReader createConsoleReader() {
        ConsoleReader consoleReader = null;
        try {
            consoleReader = new ConsoleReader();
            consoleReader.setPrompt(this.getPrompt());
            this.history = new FileHistory(this.getHistoryFile(this.username));
            consoleReader.setHistory((History)this.history);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create jline console reader", e);
        }
        return consoleReader;
    }

    protected ConsoleReader createConsoleReaderWhithoutArgs(String enteredUserName) {
        ConsoleReader consoleReader = null;
        this.history = null;
        try {
            consoleReader = new ConsoleReader();
            consoleReader.setPrompt(this.getPrompt());
            this.history = new FileHistory(this.getHistoryFile(enteredUserName));
            consoleReader.setHistory((History)this.history);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create jline console reader", e);
        }
        return consoleReader;
    }

    public ConsoleReader getConsoleReader() {
        return this.reader;
    }

    protected abstract String getPrompt();

    protected abstract File getHistoryFile(String var1);

    public final void start(String[] args) {
        Thread shutdownHookThread = new Thread("CLI Shutdown Hook"){

            @Override
            public void run() {
                CommandLineApplication.this.performDestroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        int returnCode = this.run(args);
        if (log.isDebugEnabled()) {
            log.debug("Exiting with error code {}", (Object)returnCode);
        }
        System.exit(returnCode);
    }

    protected abstract int run(String[] var1);

    protected void promptLoop() {
        String line = null;
        boolean exit = false;
        try {
            while (!exit && this.reader != null && (line = this.reader.readLine()) != null) {
                if ("".equals(line) || !StringUtils.isNotBlank((CharSequence)line)) continue;
                this.execute(line);
                exit = "exit".equals(line.trim());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error in reading line", e);
        }
    }

    private int execute(String line) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Executing command line: \"{}\"", (Object)line);
            }
            int returnCode = this.executeCommand(line);
            if (log.isDebugEnabled()) {
                log.debug("Command line executed \"{}\". Return code: {}", (Object)line, (Object)returnCode);
            }
            return returnCode;
        }
        catch (RuntimeException e) {
            if (log.isErrorEnabled()) {
                log.error("Error executing command line: " + line, (Throwable)e);
            }
            return 1;
        }
    }

    protected abstract int executeCommand(String var1);

    private void performDestroy() {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug("Shutting down application... Invoking destroy methods");
            }
            if (this.history != null) {
                try {
                    this.history.flush();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error("Error flushing history.", (Throwable)e);
                }
            }
        }
        this.destroy();
    }

    protected void destroy() {
    }

    public String getInput(String prompt) {
        return this.getInput(prompt, null);
    }

    public String getInput(String prompt, Character mask) {
        String line = null;
        try {
            this.reader.setPrompt(prompt + ": ");
            while ((line = this.reader.readLine(mask)) != null) {
                if ("".equals(line)) continue;
                String string = line;
                return string;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error in reading line", e);
        }
        finally {
            this.reader.setPrompt("stratos> ");
        }
        return line;
    }

    public boolean getConfirmation(String prompt) {
        prompt = prompt + " [yes/no]";
        String input = "";
        int tries = 0;
        while (!("y".equals(input = this.getInput(prompt)) || "yes".equals(input) || "n".equals(input) || "no".equals(input) || ++tries >= 3)) {
        }
        return "y".equals(input) || "yes".equals(input);
    }
}

