/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.stratos.cli.GenericRestClient;
import org.apache.stratos.cli.WebClientWrapper;
import org.apache.stratos.cli.utils.CliUtils;
import org.apache.stratos.common.beans.ResponseMessageBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
implements GenericRestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private String baseURL;
    private String username;
    private String password;
    private final int TIME_OUT_PARAM = 6000000;

    public RestClient(String baseURL, String username, String password) {
        this.baseURL = baseURL;
        this.username = username;
        this.password = password;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public HttpResponse doPost(DefaultHttpClient httpClient, String resourcePath, String jsonParamString) throws IOException {
        HttpPost postRequest = new HttpPost(resourcePath);
        StringEntity input = new StringEntity(jsonParamString);
        input.setContentType("application/json");
        postRequest.setEntity((HttpEntity)input);
        String userPass = this.username + ":" + this.password;
        String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
        postRequest.addHeader("Authorization", basicAuth);
        httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient((HttpClient)httpClient);
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)6000000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)6000000);
        HttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
        return response;
    }

    @Override
    public HttpResponse doGet(DefaultHttpClient httpClient, String resourcePath) throws IOException {
        HttpGet getRequest = new HttpGet(resourcePath);
        getRequest.addHeader("Content-Type", "application/json");
        String userPass = this.username + ":" + this.password;
        String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
        getRequest.addHeader("Authorization", basicAuth);
        httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient((HttpClient)httpClient);
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)6000000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)6000000);
        HttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
        return response;
    }

    @Override
    public HttpResponse doDelete(DefaultHttpClient httpClient, String resourcePath) throws IOException {
        HttpDelete httpDelete = new HttpDelete(resourcePath);
        httpDelete.addHeader("Content-Type", "application/json");
        String userPass = this.username + ":" + this.password;
        String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
        httpDelete.addHeader("Authorization", basicAuth);
        httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient((HttpClient)httpClient);
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)6000000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)6000000);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        return response;
    }

    @Override
    public HttpResponse doPut(DefaultHttpClient httpClient, String resourcePath, String jsonParamString) throws IOException {
        HttpPut httpPutRequest = new HttpPut(resourcePath);
        StringEntity input = new StringEntity(jsonParamString);
        input.setContentType("application/json");
        httpPutRequest.setEntity((HttpEntity)input);
        String userPass = this.username + ":" + this.password;
        String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
        httpPutRequest.addHeader("Authorization", basicAuth);
        httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient((HttpClient)httpClient);
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)6000000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)6000000);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPutRequest);
        return response;
    }

    public void deployEntity(String serviceEndpoint, String entityBody, String entityName) {
        try {
            String responseMessage = this.executePost(serviceEndpoint, entityBody);
            System.out.println(responseMessage);
        }
        catch (Exception e) {
            String message = String.format("Error in adding %s", entityName);
            System.out.println(message);
            log.error(message, (Throwable)e);
        }
    }

    public void undeployEntity(String serviceEndpoint, String entityName, String entityId) {
        try {
            String responseMessage = this.executeDelete(serviceEndpoint.replace("{id}", entityId));
            System.out.println(responseMessage);
        }
        catch (Exception e) {
            String message = String.format("Error in un-deploying %s : %s", entityName, entityId);
            System.out.println(message);
            log.error(message, (Throwable)e);
        }
    }

    public void updateEntity(String serviceEndpoint, String entityBody, String entityName) {
        try {
            String responseMessage = this.executePut(serviceEndpoint, entityBody);
            System.out.println(responseMessage);
        }
        catch (Exception e) {
            String message = String.format("Error in updating %s", entityName);
            System.out.println(message);
            log.error(message, (Throwable)e);
        }
    }

    public void deleteEntity(String serviceEndpoint, String identifier, String entityName) {
        try {
            String responseMessage = this.executeDelete(serviceEndpoint);
            System.out.println(responseMessage);
        }
        catch (Exception e) {
            String message = String.format("Error in deleting %s", entityName);
            System.out.println(message);
            log.error(message, (Throwable)e);
        }
    }

    public Object getEntity(String serviceEndpoint, Class responseJsonClass, String identifierPlaceHolder, String identifier, String entityName) {
        try {
            return this.executeGet(serviceEndpoint.replace(identifierPlaceHolder, identifier), responseJsonClass);
        }
        catch (Exception e) {
            String message = String.format("Error in getting %s : %s", entityName, identifier);
            System.out.println(message);
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public Object getEntity(String serviceEndpoint, Type responseType, String identifierPlaceHolder, String identifier, String entityName) {
        try {
            return this.executeGet(serviceEndpoint.replace(identifierPlaceHolder, identifier), responseType);
        }
        catch (Exception e) {
            String message = String.format("Error in getting %s : %s", entityName, identifier);
            System.out.println(message);
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public Object listEntity(String serviceEndpoint, Class responseJsonClass, String entityName) {
        try {
            return this.executeGet(serviceEndpoint, responseJsonClass);
        }
        catch (Exception e) {
            String message = String.format("Error in listing %s", entityName);
            System.out.println(message);
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public Object listEntity(String serviceEndpoint, Type type, String entityName) {
        try {
            return this.executeGet(serviceEndpoint, type);
        }
        catch (Exception e) {
            String message = String.format("Error in listing %s", entityName);
            System.out.println(message);
            log.error(message, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executePost(String serviceEndpoint, String postBody) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.doPost(httpClient, this.getBaseURL() + serviceEndpoint, postBody);
            String result = CliUtils.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String string = ((ResponseMessageBean)gson.fromJson(result, ResponseMessageBean.class)).getMessage();
            return string;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private Object executeGet(String serviceEndpoint, Class responseJsonClass) throws Exception {
        String resultString = this.executeGet(serviceEndpoint);
        if (resultString == null) {
            return null;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return gson.fromJson(resultString, responseJsonClass);
    }

    private Object executeGet(String serviceEndpoint, Type responseJsonType) throws Exception {
        String resultString = this.executeGet(serviceEndpoint);
        if (resultString == null) {
            return null;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return gson.fromJson(resultString, responseJsonType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeGet(String serviceEndpoint) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = null;
        try {
            response = this.doGet(httpClient, this.getBaseURL() + serviceEndpoint);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode >= 400 && responseCode < 500) {
                String string = null;
                return string;
            }
            if (responseCode < 200 || responseCode >= 300) {
                CliUtils.printError(response);
                String string = null;
                return string;
            }
            String string = CliUtils.getHttpResponseString(response);
            return string;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executePut(String serviceEndpoint, String postBody) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.doPut(httpClient, this.getBaseURL() + serviceEndpoint, postBody);
            String result = CliUtils.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String string = ((ResponseMessageBean)gson.fromJson(result, ResponseMessageBean.class)).getMessage();
            return string;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeDelete(String serviceEndpoint) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.doDelete(httpClient, this.getBaseURL() + serviceEndpoint);
            String result = CliUtils.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String string = ((ResponseMessageBean)gson.fromJson(result, ResponseMessageBean.class)).getMessage();
            return string;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }
}

