/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNetworkPartitionCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(AddNetworkPartitionCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option resourcePath = new Option("p", "resource-path", true, "Network partition resource path");
        resourcePath.setArgName("resource path");
        options.addOption(resourcePath);
        return options;
    }

    @Override
    public String getName() {
        return "add-network-partition";
    }

    @Override
    public String getDescription() {
        return "Add network partition deployment";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
            log.debug("Get name" + this.getName());
        }
        if (args != null && args.length > 0) {
            String resourcePath = null;
            String resourceFileContent = null;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
                if (log.isDebugEnabled()) {
                    log.debug("Network Partition deployment");
                }
                if (opts.hasOption("p")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Resource path option is passed");
                    }
                    resourcePath = opts.getOption("p").getValue();
                    resourceFileContent = CliUtils.readResource(resourcePath);
                }
                if (resourcePath == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                RestCommandLineService.getInstance().addNetworkPartition(resourceFileContent);
                return 0;
            }
            catch (ParseException e) {
                log.error("Error parsing arguments", (Throwable)e);
                System.out.println(e.getMessage());
                return 1;
            }
            catch (IOException e) {
                System.out.println("Invalid resource path");
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

