/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTenantCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(AddTenantCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option usernameOption = new Option("u", "username", true, "Tenant user name");
        usernameOption.setArgName("username");
        options.addOption(usernameOption);
        Option firstnameOption = new Option("f", "first-name", true, "Tenant first name");
        firstnameOption.setArgName("firstname");
        options.addOption(firstnameOption);
        Option lastnameOption = new Option("l", "last-name", true, "Tenant last name");
        lastnameOption.setArgName("lastname");
        options.addOption(lastnameOption);
        Option passwordOption = new Option("p", "password", true, "Tenant password");
        passwordOption.setArgName("password");
        options.addOption(passwordOption);
        Option domainOption = new Option("d", "domain-name", true, "Tenant domain");
        domainOption.setArgName("domain");
        options.addOption(domainOption);
        Option emailOption = new Option("e", "email", true, "Tenant email");
        emailOption.setArgName("email");
        options.addOption(emailOption);
        return options;
    }

    @Override
    public String getName() {
        return "add-tenant";
    }

    @Override
    public String getDescription() {
        return "Add new tenant";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String admin = null;
            String firstName = null;
            String lastName = null;
            String password = null;
            String domain = null;
            String email = null;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
                if (log.isDebugEnabled()) {
                    log.debug("Add tenant");
                }
                if (opts.hasOption("u")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Username option is passed");
                    }
                    admin = opts.getOption("u").getValue();
                }
                if (opts.hasOption("f")) {
                    if (log.isTraceEnabled()) {
                        log.trace("First name option is passed");
                    }
                    firstName = opts.getOption("f").getValue();
                }
                if (opts.hasOption("l")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Last name option is passed");
                    }
                    lastName = opts.getOption("l").getValue();
                }
                if (opts.hasOption("p")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Password option is passed");
                    }
                    password = opts.getOption("p").getValue();
                }
                if (opts.hasOption("d")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Domain name option is passed");
                    }
                    domain = opts.getOption("d").getValue();
                }
                if (opts.hasOption("e")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Email option is passed");
                    }
                    email = opts.getOption("e").getValue();
                }
                if (admin == null || firstName == null || lastName == null || password == null || domain == null || email == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                RestCommandLineService.getInstance().addTenant(admin, firstName, lastName, password, domain, email);
                return 0;
            }
            catch (ParseException e) {
                log.error("Error parsing arguments", (Throwable)e);
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

