/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployApplicationCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(DeployApplicationCommand.class);
    private Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option applicationOption = new Option("a", "application-id", true, "Application option");
        applicationOption.setArgName("applicationId");
        options.addOption(applicationOption);
        Option applicationPolicyOption = new Option("ap", "application-policy-id", true, "Application policy");
        applicationPolicyOption.setArgName("applicationPolicyId");
        options.addOption(applicationPolicyOption);
        return options;
    }

    @Override
    public String getName() {
        return "deploy-application";
    }

    @Override
    public String getDescription() {
        return "Deploy application";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String applicationId = null;
            String applicationPolicyId = null;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
                if (log.isDebugEnabled()) {
                    log.debug("Deploy application");
                }
                if (opts.hasOption("a")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Application id option is passed");
                    }
                    applicationId = opts.getOption("a").getValue();
                }
                if (opts.hasOption("ap")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Application policy id option is passed");
                    }
                    applicationPolicyId = opts.getOption("ap").getValue();
                }
                if (applicationId == null || applicationPolicyId == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                RestCommandLineService.getInstance().deployApplication(applicationId, applicationPolicyId);
                return 0;
            }
            catch (ParseException e) {
                log.error("Error parsing arguments", (Throwable)e);
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

