/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribeCartridgeCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(DescribeCartridgeCommand.class);

    @Override
    public String getName() {
        return "describe-cartridge";
    }

    @Override
    public String getDescription() {
        return "Describe cartridge";
    }

    @Override
    public String getArgumentSyntax() {
        return "[cartridge-type]";
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 1) {
            String cartridgeType = args[0];
            if (log.isDebugEnabled()) {
                log.debug("Getting cartridge info {}", (Object)cartridgeType);
            }
            RestCommandLineService.getInstance().describeCartridge(cartridgeType);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

