/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListKubernetesHostsCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(ListKubernetesHostsCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option clusterId = new Option("c", "cluster-id", true, "Cluster id");
        clusterId.setArgName("cluster id");
        options.addOption(clusterId);
        return options;
    }

    @Override
    public String getName() {
        return "list-kubernetes-hosts";
    }

    @Override
    public String getDescription() {
        return "List Kubernetes hosts";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String clusterId = null;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
                if (log.isDebugEnabled()) {
                    log.debug("List Kubernetes hosts of a cluster");
                }
                if (opts.hasOption("c")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Cluster id option is passed");
                    }
                    clusterId = opts.getOption("c").getValue();
                }
                if (clusterId == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                RestCommandLineService.getInstance().listKubernetesHosts(clusterId);
                return 0;
            }
            catch (ParseException e) {
                log.error("Error parsing arguments", (Throwable)e);
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

