/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTenants
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(ListTenants.class);

    @Override
    public String getName() {
        return "list-tenants";
    }

    @Override
    public String getDescription() {
        return "List available tenants";
    }

    @Override
    public String getArgumentSyntax() {
        return "[partial-domain]";
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args == null || args.length == 0) {
            RestCommandLineService.getInstance().listTenants();
            return 0;
        }
        if (args[0] != null) {
            String partialDomainName = args[0];
            RestCommandLineService.getInstance().listTenantsByPartialDomain(partialDomainName);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return null;
    }
}

