/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizeArtifactsCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(SynchronizeArtifactsCommand.class);

    @Override
    public String getName() {
        return "synchronize-artifacts";
    }

    @Override
    public String getDescription() {
        return "Synchronize artifacts with Git repository for cartridge subscriptions";
    }

    @Override
    public String getArgumentSyntax() {
        return "[cartridge-subscription-alias]";
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 1) {
            String cartridgeSubscriptionAlias = args[0];
            if (log.isDebugEnabled()) {
                log.debug("Synchronizing repository for cartridge subscription alias {}", (Object)cartridgeSubscriptionAlias);
            }
            RestCommandLineService.getInstance().synchronizeArtifacts(cartridgeSubscriptionAlias);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return null;
    }
}

