/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateKubernetesMasterCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(UpdateKubernetesMasterCommand.class);
    private Options options = new Options();

    public UpdateKubernetesMasterCommand() {
        Option resourcePathOption = new Option("p", "resource-path", true, "Kubernetes master resource path");
        resourcePathOption.setArgName("resource path");
        this.options.addOption(resourcePathOption);
        Option clusterIdOption = new Option("c", "cluster-id", true, "Kubernetes cluster id");
        clusterIdOption.setArgName("cluster id");
        this.options.addOption(clusterIdOption);
    }

    @Override
    public String getName() {
        return "update-kubernetes-master";
    }

    @Override
    public String getDescription() {
        return "Update Kubernetes master";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing command: ", (Object)this.getName());
        }
        if (args == null || args.length <= 0) {
            context.getStratosApplication().printUsage(this.getName());
            return 1;
        }
        try {
            GnuParser parser = new GnuParser();
            CommandLine commandLine = parser.parse(this.options, args);
            Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
            if (opts.hasOption("p") && opts.hasOption("c")) {
                String clusterId = opts.getOption("c").getValue();
                if (clusterId == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                String resourcePath = opts.getOption("p").getValue();
                if (resourcePath == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                String resourceFileContent = CliUtils.readResource(resourcePath);
                RestCommandLineService.getInstance().updateKubernetesMaster(resourceFileContent, clusterId);
                return 0;
            }
            context.getStratosApplication().printUsage(this.getName());
            return 1;
        }
        catch (ParseException e) {
            log.error("Error parsing arguments", (Throwable)e);
            System.out.println(e.getMessage());
            return 1;
        }
        catch (IOException e) {
            System.out.println("Invalid resource path");
            return 1;
        }
        catch (Exception e) {
            String message = "Unknown error occurred: " + e.getMessage();
            System.out.println(message);
            log.error(message, (Throwable)e);
            return 1;
        }
    }
}

