/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.stratos.cli.exception.ExceptionMapper;
import org.apache.stratos.cli.utils.RowMapper;

public class CliUtils {
    private static Log log = LogFactory.getLog(CliUtils.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("Resources");

    public static <T> void printTable(T[] data, RowMapper<T> mapper, String ... headers) {
        int i;
        if (data == null) {
            return;
        }
        int columns = headers.length;
        int rows = data.length + 1;
        String[][] table = new String[rows][columns];
        table[0] = headers;
        for (int i2 = 0; i2 < data.length; ++i2) {
            T t = data[i2];
            table[i2 + 1] = mapper.getData(t);
        }
        int[] lengths = new int[columns];
        for (int i3 = 0; i3 < table.length; ++i3) {
            for (int j = 0; j < table[i3].length; ++j) {
                lengths[j] = Math.max(table[i3][j].length(), lengths[j]);
            }
        }
        String[] borders = new String[lengths.length];
        String[] formats = new String[lengths.length];
        for (i = 0; i < lengths.length; ++i) {
            boolean finalColumn;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("+");
            for (int j = 0; j < lengths[i] + 2; ++j) {
                stringBuilder.append("-");
            }
            boolean bl = finalColumn = i + 1 == lengths.length;
            if (finalColumn) {
                stringBuilder.append("+\n");
            }
            borders[i] = stringBuilder.toString();
            formats[i] = "| %1$-" + lengths[i] + "s " + (finalColumn ? "|\n" : "");
        }
        for (i = 0; i < table.length; ++i) {
            int j;
            for (j = 0; j < table[i].length; ++j) {
                System.out.print(borders[j]);
            }
            for (j = 0; j < table[i].length; ++j) {
                System.out.format(formats[j], table[i][j]);
            }
            if (i + 1 != table.length) continue;
            for (j = 0; j < table[i].length; ++j) {
                System.out.print(borders[j]);
            }
        }
    }

    public static String getMessage(String key, Object ... args) {
        String message = BUNDLE.getString(key);
        if (args != null && args.length > 0) {
            message = MessageFormat.format(message, args);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(String fileName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(LINE_SEPARATOR);
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    public static String getHttpResponseString(HttpResponse response) {
        try {
            String result = "";
            if (response != null && response.getEntity() != null && response.getEntity().getContent() != null) {
                String output;
                BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                while ((output = reader.readLine()) != null) {
                    result = result + output;
                }
            }
            return result;
        }
        catch (SocketException e) {
            String message = "A connection error occurred while reading response message: " + e.getMessage();
            System.out.println(message);
            log.error((Object)message, (Throwable)e);
            return null;
        }
        catch (IOException e) {
            String message = "An IO error occurred while reading response message: " + e.getMessage();
            System.out.println(message);
            log.error((Object)message, (Throwable)e);
            return null;
        }
        catch (Exception e) {
            String message = "An unknown error occurred while reading response message: " + e.getMessage();
            System.out.println(message);
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void printError(HttpResponse response) {
        String resultString = CliUtils.getHttpResponseString(response);
        if (StringUtils.isNotBlank((CharSequence)resultString)) {
            boolean exceptionMapperInstanceFound = false;
            try {
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                ExceptionMapper exception = (ExceptionMapper)gson.fromJson(resultString, ExceptionMapper.class);
                if (exception == null) return;
                System.out.println(exception);
                exceptionMapperInstanceFound = true;
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                if (!exceptionMapperInstanceFound) {
                    System.out.println(response.getStatusLine().toString());
                }
            }
        } else {
            System.out.println(response.getStatusLine().toString());
        }
    }

    public static Options mergeOptionArrays(Option[] a, Option[] b) {
        Options opts = new Options();
        for (Option o : a) {
            opts.addOption(o);
        }
        for (Option o : b) {
            opts.addOption(o);
        }
        return opts;
    }
}

