/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import java.io.File;
import org.apache.stratos.cli.StratosApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliTool {
    private static final Logger log = LoggerFactory.getLogger(CliTool.class);

    void handleConsoleInputs(String[] arguments) {
        if (log.isInfoEnabled()) {
            log.info("Stratos CLI started...");
        }
        StratosApplication application = new StratosApplication(arguments);
        application.start(arguments);
    }

    void createConfigDirectory() {
        File stratosFile = new File(System.getProperty("user.home"), ".stratos");
        if (stratosFile.exists()) {
            if (log.isInfoEnabled()) {
                log.info("Using directory: {}", (Object)stratosFile.getPath());
            }
        } else if (stratosFile.mkdir()) {
            if (log.isInfoEnabled()) {
                log.info("Created directory: {}", (Object)stratosFile.getPath());
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Failed to created directory: {}", (Object)stratosFile.getPath());
        }
    }
}

