/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.stratos.cli.RestClient;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.exception.ExceptionMapper;
import org.apache.stratos.cli.utils.CliUtils;
import org.apache.stratos.cli.utils.RowMapper;
import org.apache.stratos.common.beans.ResponseMessageBean;
import org.apache.stratos.common.beans.TenantInfoBean;
import org.apache.stratos.common.beans.UserInfoBean;
import org.apache.stratos.common.beans.application.ApplicationBean;
import org.apache.stratos.common.beans.application.domain.mapping.DomainMappingBean;
import org.apache.stratos.common.beans.application.signup.ApplicationSignUpBean;
import org.apache.stratos.common.beans.cartridge.CartridgeBean;
import org.apache.stratos.common.beans.cartridge.CartridgeGroupBean;
import org.apache.stratos.common.beans.kubernetes.KubernetesClusterBean;
import org.apache.stratos.common.beans.kubernetes.KubernetesHostBean;
import org.apache.stratos.common.beans.kubernetes.KubernetesMasterBean;
import org.apache.stratos.common.beans.partition.NetworkPartitionBean;
import org.apache.stratos.common.beans.policy.autoscale.AutoscalePolicyBean;
import org.apache.stratos.common.beans.policy.deployment.ApplicationPolicyBean;
import org.apache.stratos.common.beans.policy.deployment.DeploymentPolicyBean;
import org.apache.stratos.common.beans.topology.ClusterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCommandLineService {
    private static final Logger log = LoggerFactory.getLogger(RestCommandLineService.class);
    private RestClient restClient;
    private static final String API_CONTEXT = "/api/v4.1";
    private static final String ENDPOINT_INIT = "/api/v4.1/init";
    private static final String ENDPOINT_ADD_TENANT = "/api/v4.1/tenants";
    private static final String ENDPOINT_ADD_USER = "/api/v4.1/users";
    private static final String ENDPOINT_ADD_APPLICATION = "/api/v4.1/applications";
    private static final String ENDPOINT_DEPLOY_CARTRIDGE = "/api/v4.1/cartridges";
    private static final String ENDPOINT_DEPLOY_AUTOSCALING_POLICY = "/api/v4.1/autoscalingPolicies";
    private static final String ENDPOINT_DEPLOY_APPLICATION_POLICY = "/api/v4.1/applicationPolicies";
    private static final String ENDPOINT_DEPLOY_DEPLOYMENT_POLICY = "/api/v4.1/deploymentPolicies";
    private static final String ENDPOINT_DEPLOY_KUBERNETES_CLUSTER = "/api/v4.1/kubernetesClusters";
    private static final String ENDPOINT_DEPLOY_KUBERNETES_HOST = "/api/v4.1/kubernetesClusters/{kubernetesClusterId}/minion";
    private static final String ENDPOINT_DEPLOY_SERVICE_GROUP = "/api/v4.1/cartridgeGroups";
    private static final String ENDPOINT_DEPLOY_APPLICATION = "/api/v4.1/applications/{applicationId}/deploy/{applicationPolicyId}";
    private static final String ENDPOINT_DEPLOY_NETWORK_PARTITION = "/api/v4.1/networkPartitions";
    private static final String ENDPOINT_UNDEPLOY_KUBERNETES_CLUSTER = "/api/v4.1/kubernetesClusters/{id}";
    private static final String ENDPOINT_UNDEPLOY_KUBERNETES_HOST = "/api/v4.1/kubernetesClusters/{kubernetesClusterId}/hosts/{id}";
    private static final String ENDPOINT_UNDEPLOY_SERVICE_GROUP = "/api/v4.1/cartridgeGroups/{id}";
    private static final String ENDPOINT_UNDEPLOY_APPLICATION = "/api/v4.1/applications/{id}/undeploy";
    private static final String ENDPOINT_UNDEPLOY_CARTRIDGE = "/api/v4.1/cartridges/{id}";
    private static final String ENDPOINT_REMOVE_APPLICATION = "/api/v4.1/applications/{appId}";
    private static final String ENDPOINT_REMOVE_NETWORK_PARTITION = "/api/v4.1/networkPartitions/{id}";
    private static final String ENDPOINT_REMOVE_AUTOSCALINGPOLICY = "/api/v4.1/autoscalingPolicies/{policyId}";
    private static final String ENDPOINT_REMOVE_DEPLOYMENT_POLICY = "/api/v4.1/deploymentPolicies/{policyId}";
    private static final String ENDPOINT_REMOVE_APPLICATION_POLICY = "/api/v4.1/applicationPolicies/{policyId}";
    private static final String ENDPOINT_LIST_AUTOSCALING_POLICIES = "/api/v4.1/autoscalingPolicies";
    private static final String ENDPOINT_LIST_DEPLOYMENT_POLICIES = "/api/v4.1/deploymentPolicies";
    private static final String ENDPOINT_LIST_APPLICATION_POLICIES = "/api/v4.1/applicationPolicies";
    private static final String ENDPOINT_LIST_CARTRIDGES = "/api/v4.1/cartridges";
    private static final String ENDPOINT_LIST_CARTRIDGE_GROUPS = "/api/v4.1/cartridgeGroups";
    private static final String ENDPOINT_LIST_TENANTS = "/api/v4.1/tenants";
    private static final String ENDPOINT_LIST_USERS = "/api/v4.1/users";
    private static final String ENDPOINT_LIST_KUBERNETES_CLUSTERS = "/api/v4.1/kubernetesClusters";
    private static final String ENDPOINT_LIST_KUBERNETES_HOSTS = "/api/v4.1/kubernetesClusters/{kubernetesClusterId}/hosts";
    private static final String ENDPOINT_LIST_SERVICE_GROUP = "/api/v4.1/cartridgeGroups/{groupDefinitionName}";
    private static final String ENDPOINT_LIST_APPLICATION = "/api/v4.1/applications";
    private static final String ENDPOINT_LIST_NETWORK_PARTITIONS = "/api/v4.1/networkPartitions";
    private static final String ENDPOINT_LIST_CARTRIDGES_BY_FILTER = "/api/v4.1/cartridges/filter/{filter}";
    private static final String ENDPOINT_LIST_TENANTS_BY_PARTIAL_DOMAIN = "/api/v4.1/tenants/search/{tenantDomain}";
    private static final String ENDPOINT_DOMAIN_MAPPINGS = "/api/v4.1/applications/{applicationId}/domainMappings";
    private static final String ENDPOINT_REMOVE_DOMAIN_MAPPINGS = "/api/v4.1/applications/{applicationId}/domainMappings/{domainName}";
    private static final String ENDPOINT_GET_APPLICATION = "/api/v4.1/applications/{appId}";
    private static final String ENDPOINT_GET_AUTOSCALING_POLICY = "/api/v4.1/autoscalingPolicies/{id}";
    private static final String ENDPOINT_GET_DEPLOYMENT_POLICY = "/api/v4.1/deploymentPolicies/{deploymentPolicyId}";
    private static final String ENDPOINT_GET_APPLICATION_POLICY = "/api/v4.1/applicationPolicies/{applicationPolicyId}";
    private static final String ENDPOINT_GET_KUBERNETES_MASTER = "/api/v4.1/kubernetesClusters/{kubernetesClusterId}/master";
    private static final String ENDPOINT_GET_KUBERNETES_HOST_CLUSTER = "/api/v4.1/kubernetesClusters/{kubernetesClusterId}";
    private static final String ENDPOINT_GET_NETWORK_PARTITION = "/api/v4.1/networkPartitions/{networkPartitionId}";
    private static final String ENDPOINT_GET_APPLICATION_RUNTIME = "/api/v4.1/applications/{applicationId}/runtime";
    private static final String ENDPOINT_UPDATE_KUBERNETES_MASTER = "/api/v4.1/kubernetesClusters/{kubernetesClusterId}/master";
    private static final String ENDPOINT_UPDATE_KUBERNETES_HOST = "/api/v4.1/kubernetesClusters/host";
    private static final String ENDPOINT_SYNCHRONIZE_ARTIFACTS = "/api/v4.1/repo/synchronize/{subscriptionAlias}";
    private static final String ENDPOINT_ACTIVATE_TENANT = "/api/v4.1/tenants/activate/{tenantDomain}";
    private static final String ENDPOINT_DEACTIVATE_TENANT = "/api/v4.1/tenants/deactivate/{tenantDomain}";
    private static final String ENDPOINT_APPLICATION_SIGNUP = "/api/v4.1/applications/{applicationId}/signup";
    private static final String ENDPOINT_UPDATE_DEPLOYMENT_POLICY = "/api/v4.1/deploymentPolicies";
    private static final String ENDPOINT_UPDATE_APPLICATION = "/api/v4.1/applications";
    private static final String ENDPOINT_UPDATE_APPLICATION_POLICY = "/api/v4.1/applicationPolicies";
    private static final String ENDPOINT_UPDATE_AUTOSCALING_POLICY = "/api/v4.1/autoscalingPolicies";
    private static final String ENDPOINT_UPDATE_USER = "/api/v4.1/users";
    private static final String ENDPOINT_UPDATE_TENANT = "/api/v4.1/tenants";

    public static RestCommandLineService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        return gsonBuilder.setPrettyPrinting().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String serverURL, String username, String password, boolean validateLogin) throws Exception {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLContext.setDefault(sc);
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while authentication process!", e);
        }
        try {
            this.initializeRestClient(serverURL, username, password);
            if (log.isDebugEnabled()) {
                log.debug("Initialized REST Client for user {}", (Object)username);
            }
        }
        catch (AxisFault e) {
            String message = "Error connecting to the stratos server";
            this.printError(message, e);
            throw new CommandException(e);
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            if (validateLogin) {
                HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + ENDPOINT_INIT);
                if (response != null) {
                    int responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode == 200) {
                        boolean bl = true;
                        return bl;
                    }
                    System.out.println("Invalid value is set for STRATOS_URL");
                }
                boolean responseCode = false;
                return responseCode;
            }
            boolean response = true;
            return response;
        }
        catch (ConnectException e) {
            String message = "Could not connect to stratos manager";
            this.printError(message, e);
            boolean bl = false;
            return bl;
        }
        catch (NoSuchMethodError e) {
            String message = "Authentication failed!";
            this.printError(message, e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (e.getCause() instanceof MalformedChallengeException) {
                String message = "Authentication failed. Please check your username/password";
                this.printError(message, e);
                boolean bl = false;
                return bl;
            }
            String message = "An unknown error occurred: " + e.getMessage();
            this.printError(message, e);
            boolean bl = false;
            return bl;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private void initializeRestClient(String serverURL, String username, String password) throws AxisFault {
        ConfigurationContext configurationContext;
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername(username);
        authenticator.setPassword(password);
        authenticator.setPreemptiveAuthentication(true);
        try {
            configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
        }
        catch (Exception e) {
            String msg = "Backend error occurred. Please contact the service admins!";
            throw new AxisFault(msg, (Throwable)e);
        }
        HashMap transportsOut = configurationContext.getAxisConfiguration().getTransportsOut();
        for (TransportOutDescription transportOutDescription : transportsOut.values()) {
            transportOutDescription.getSender().init(configurationContext, transportOutDescription);
        }
        this.restClient = new RestClient(serverURL, username, password);
    }

    public void listCartridges() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<CartridgeBean>>(){}.getType();
            List cartridgeList = (List)this.restClient.listEntity("/api/v4.1/cartridges", listType, "cartridges");
            if (cartridgeList == null || cartridgeList.size() == 0) {
                System.out.println("No cartridges found");
                return;
            }
            RowMapper<CartridgeBean> cartridgeMapper = new RowMapper<CartridgeBean>(){

                @Override
                public String[] getData(CartridgeBean cartridge) {
                    String[] data = new String[]{cartridge.getType(), cartridge.getCategory(), cartridge.getDisplayName(), cartridge.getDescription(), cartridge.getVersion(), String.valueOf(cartridge.isMultiTenant())};
                    return data;
                }
            };
            CartridgeBean[] cartridges = new CartridgeBean[cartridgeList.size()];
            cartridges = cartridgeList.toArray(cartridges);
            System.out.println("Cartridges found:");
            CliUtils.printTable(cartridges, cartridgeMapper, "Type", "Category", "Name", "Description", "Version", "Multi-Tenant");
        }
        catch (Exception e) {
            String message = "Error in listing cartridges";
            this.printError(message, e);
        }
    }

    public void listCartridgesByFilter(String filter) throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<CartridgeBean>>(){}.getType();
            List cartridgeList = (List)this.restClient.listEntity(ENDPOINT_LIST_CARTRIDGES_BY_FILTER.replace("{filter}", filter), listType, "cartridges");
            System.out.println("Test:" + ENDPOINT_LIST_CARTRIDGES_BY_FILTER.replace("{filter}", filter));
            if (cartridgeList == null || cartridgeList.size() == 0) {
                System.out.println("No cartridges found");
                return;
            }
            RowMapper<CartridgeBean> cartridgeMapper = new RowMapper<CartridgeBean>(){

                @Override
                public String[] getData(CartridgeBean cartridge) {
                    String[] data = new String[]{cartridge.getType(), cartridge.getCategory(), cartridge.getDisplayName(), cartridge.getDescription(), cartridge.getVersion(), String.valueOf(cartridge.isMultiTenant())};
                    return data;
                }
            };
            CartridgeBean[] cartridges = new CartridgeBean[cartridgeList.size()];
            cartridges = cartridgeList.toArray(cartridges);
            System.out.println("Cartridges found:");
            CliUtils.printTable(cartridges, cartridgeMapper, "Type", "Category", "Name", "Description", "Version", "Multi-Tenant");
        }
        catch (Exception e) {
            String message = "Error in listing cartridges";
            this.printError(message, e);
        }
    }

    public void listCartridgeGroups() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<CartridgeGroupBean>>(){}.getType();
            List cartridgeGroupList = (List)this.restClient.listEntity("/api/v4.1/cartridgeGroups", listType, "Cartridge Groups");
            if (cartridgeGroupList == null || cartridgeGroupList.size() == 0) {
                System.out.println("No cartridge groups found");
                return;
            }
            RowMapper<CartridgeGroupBean> cartridgeGroupMapper = new RowMapper<CartridgeGroupBean>(){

                @Override
                public String[] getData(CartridgeGroupBean cartridgeGroup) {
                    String[] data = new String[]{cartridgeGroup.getName(), cartridgeGroup.getCartridges() == null ? "" : String.valueOf(cartridgeGroup.getCartridges().size()), cartridgeGroup.getGroups() == null ? "0" : String.valueOf(cartridgeGroup.getGroups().size())};
                    return data;
                }
            };
            CartridgeGroupBean[] cartridgeGroups = new CartridgeGroupBean[cartridgeGroupList.size()];
            cartridgeGroups = cartridgeGroupList.toArray(cartridgeGroups);
            System.out.println("Cartridge Groups found:");
            CliUtils.printTable(cartridgeGroups, cartridgeGroupMapper, "Name", "No. of cartridges", "No of groups");
        }
        catch (Exception e) {
            String message = "Error in listing cartridge groups";
            this.printError(message, e);
        }
    }

    public void describeCartridge(String cartridgeType) throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<CartridgeBean>>(){}.getType();
            List cartridgeList = (List)this.restClient.listEntity("/api/v4.1/cartridges", listType, "cartridges");
            CartridgeBean cartridge = null;
            for (CartridgeBean item : cartridgeList) {
                if (!item.getType().equals(cartridgeType)) continue;
                cartridge = item;
                break;
            }
            if (cartridge == null) {
                System.out.println("Cartridge not found");
                return;
            }
            System.out.println(this.getGson().toJson(cartridge));
        }
        catch (Exception e) {
            String message = "Error in describing cartridge: " + cartridgeType;
            this.printError(message, e);
        }
    }

    private ClusterBean getClusterObjectFromString(String resultString) {
        if (resultString.startsWith("{\"cluster\"")) {
            String tmp;
            resultString = tmp = resultString.substring("{\"cluster\"".length() + 1, resultString.length() - 1);
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return (ClusterBean)gson.fromJson(resultString, ClusterBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTenant(String admin, String firstName, String lastName, String password, String domain, String email) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            TenantInfoBean tenantInfo = new TenantInfoBean();
            tenantInfo.setAdmin(admin);
            tenantInfo.setFirstName(firstName);
            tenantInfo.setLastName(lastName);
            tenantInfo.setAdminPassword(password);
            tenantInfo.setTenantDomain(domain);
            tenantInfo.setEmail(email);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String jsonString = gson.toJson((Object)tenantInfo, TenantInfoBean.class);
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/api/v4.1/tenants", jsonString);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 201) {
                System.out.println("Tenant added successfully: " + domain);
            } else {
                String resultString = CliUtils.getHttpResponseString(response);
                String errorMsg = ((ResponseMessageBean)gson.fromJson(resultString, ResponseMessageBean.class)).getMessage();
                System.out.println(errorMsg);
            }
        }
        catch (Exception e) {
            String message = "Could not add tenant: " + domain;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public void describeTenant(String domainName) throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<TenantInfoBean>>(){}.getType();
            List tenantList = (List)this.restClient.listEntity("/api/v4.1/tenants", listType, "tenant");
            TenantInfoBean tenant = null;
            for (TenantInfoBean item : tenantList) {
                if (!item.getTenantDomain().equals(domainName)) continue;
                tenant = item;
                break;
            }
            if (tenant == null) {
                System.out.println("Tenant not found");
                return;
            }
            System.out.println("-------------------------------------");
            System.out.println("Tenant Information:");
            System.out.println("-------------------------------------");
            System.out.println("Tenant domain: " + tenant.getTenantDomain());
            System.out.println("ID: " + tenant.getTenantId());
            System.out.println("Email: " + tenant.getEmail());
            System.out.println("Active: " + tenant.isActive());
            System.out.println("Created date: " + new Date(tenant.getCreatedDate()));
        }
        catch (Exception e) {
            String message = "Error in describing tenant: " + domainName;
            this.printError(message, e);
        }
    }

    public void listTenantsByPartialDomain(String partialDomain) throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<TenantInfoBean>>(){}.getType();
            List tenantList = (List)this.restClient.listEntity(ENDPOINT_LIST_TENANTS_BY_PARTIAL_DOMAIN.replace("{tenantDomain}", partialDomain), listType, "tenants");
            if (tenantList == null || tenantList.size() == 0) {
                System.out.println("No tenants found");
                return;
            }
            RowMapper<TenantInfoBean> tenantMapper = new RowMapper<TenantInfoBean>(){

                @Override
                public String[] getData(TenantInfoBean tenant) {
                    String[] data = new String[]{tenant.getTenantDomain(), String.valueOf(tenant.getTenantId()), String.valueOf(tenant.isActive()), tenant.getEmail(), new Date(tenant.getCreatedDate()).toString()};
                    return data;
                }
            };
            TenantInfoBean[] tenants = new TenantInfoBean[tenantList.size()];
            tenants = tenantList.toArray(tenants);
            System.out.println("Tenants found:");
            CliUtils.printTable(tenants, tenantMapper, "tenantDomain", "tenantID", "active", "email", "createdDate");
        }
        catch (Exception e) {
            String message = "Error in listing tenants";
            this.printError(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTenant(int id, String admin, String firstName, String lastName, String password, String domain, String email) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            TenantInfoBean tenantInfo = new TenantInfoBean();
            tenantInfo.setAdmin(admin);
            tenantInfo.setFirstName(firstName);
            tenantInfo.setLastName(lastName);
            tenantInfo.setAdminPassword(password);
            tenantInfo.setTenantDomain(domain);
            tenantInfo.setEmail(email);
            tenantInfo.setTenantId(id);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String jsonString = gson.toJson((Object)tenantInfo, TenantInfoBean.class);
            HttpResponse response = this.restClient.doPut(httpClient, this.restClient.getBaseURL() + "/api/v4.1/tenants", jsonString);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode < 200 || responseCode >= 300) {
                String resultString = CliUtils.getHttpResponseString(response);
                String errorMsg = ((ResponseMessageBean)gson.fromJson(resultString, ResponseMessageBean.class)).getMessage();
                System.out.println(errorMsg);
            } else {
                System.out.println("Tenant updated successfully: " + domain);
            }
        }
        catch (Exception e) {
            String message = "Could not update tenant: " + domain;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String userName, String credential, String role, String firstName, String lastName, String email, String profileName) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            UserInfoBean userInfoBean = new UserInfoBean();
            userInfoBean.setUserName(userName);
            userInfoBean.setCredential(credential);
            userInfoBean.setRole(role);
            userInfoBean.setFirstName(firstName);
            userInfoBean.setLastName(lastName);
            userInfoBean.setEmail(email);
            userInfoBean.setProfileName(profileName);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String jsonString = gson.toJson((Object)userInfoBean, UserInfoBean.class);
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/api/v4.1/users", jsonString);
            String result = CliUtils.getHttpResponseString(response);
            System.out.println(((ResponseMessageBean)gson.fromJson(result, ResponseMessageBean.class)).getMessage());
        }
        catch (Exception e) {
            String message = "Could not add user: " + userName;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(String userName, String credential, String role, String firstName, String lastName, String email, String profileName) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            UserInfoBean userInfoBean = new UserInfoBean();
            userInfoBean.setUserName(userName);
            userInfoBean.setCredential(credential);
            userInfoBean.setRole(role);
            userInfoBean.setFirstName(firstName);
            userInfoBean.setLastName(lastName);
            userInfoBean.setEmail(email);
            userInfoBean.setProfileName(profileName);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String jsonString = gson.toJson((Object)userInfoBean, UserInfoBean.class);
            HttpResponse response = this.restClient.doPut(httpClient, this.restClient.getBaseURL() + "/api/v4.1/users", jsonString);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode < 200 || responseCode >= 300) {
                CliUtils.printError(response);
            } else {
                System.out.println("User updated successfully: " + userName);
            }
        }
        catch (Exception e) {
            String message = "Could not update user: " + userName;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTenant(String tenantDomain) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doDelete(httpClient, this.restClient.getBaseURL() + "/api/v4.1/tenants" + "/" + tenantDomain);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have successfully deleted the tenant: " + tenantDomain);
            } else {
                String resultString = CliUtils.getHttpResponseString(response);
                ExceptionMapper exception = (ExceptionMapper)gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
            }
        }
        catch (Exception e) {
            String message = "Could not delete tenant: " + tenantDomain;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String userName) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doDelete(httpClient, this.restClient.getBaseURL() + "/api/v4.1/users" + "/" + userName);
            String resultString = CliUtils.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            System.out.println(((ResponseMessageBean)gson.fromJson(resultString, ResponseMessageBean.class)).getMessage());
        }
        catch (Exception e) {
            String message = "Could not delete user: " + userName;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateTenant(String tenantDomain) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPut(httpClient, this.restClient.getBaseURL() + ENDPOINT_DEACTIVATE_TENANT.replace("{tenantDomain}", tenantDomain), "");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have successfully deactivated the tenant: " + tenantDomain);
                return;
            }
            String resultString = CliUtils.getHttpResponseString(response);
            String errorMsg = ((ResponseMessageBean)gson.fromJson(resultString, ResponseMessageBean.class)).getMessage();
            System.out.println(errorMsg);
        }
        catch (Exception e) {
            String message = "Could not de-activate tenant: " + tenantDomain;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTenant(String tenantDomain) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPut(httpClient, this.restClient.getBaseURL() + ENDPOINT_ACTIVATE_TENANT.replace("{tenantDomain}", tenantDomain), "");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have successfully activated the tenant: " + tenantDomain);
            } else {
                String resultString = CliUtils.getHttpResponseString(response);
                String errorMsg = ((ResponseMessageBean)gson.fromJson(resultString, ResponseMessageBean.class)).getMessage();
                System.out.println(errorMsg);
            }
        }
        catch (Exception e) {
            String message = "Could not activate tenant: " + tenantDomain;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public void listTenants() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<TenantInfoBean>>(){}.getType();
            List tenantInfoList = (List)this.restClient.listEntity("/api/v4.1/tenants", listType, "tenants");
            if (tenantInfoList == null || tenantInfoList.size() == 0) {
                System.out.println("No tenants found");
                return;
            }
            RowMapper<TenantInfoBean> rowMapper = new RowMapper<TenantInfoBean>(){

                @Override
                public String[] getData(TenantInfoBean tenantInfo) {
                    String[] data = new String[]{tenantInfo.getTenantDomain(), "" + tenantInfo.getTenantId(), tenantInfo.getEmail(), tenantInfo.isActive() ? "Active" : "De-active", new Date(tenantInfo.getCreatedDate()).toString()};
                    return data;
                }
            };
            TenantInfoBean[] tenantArray = new TenantInfoBean[tenantInfoList.size()];
            tenantArray = tenantInfoList.toArray(tenantArray);
            System.out.println("Tenants:");
            CliUtils.printTable(tenantArray, rowMapper, "Domain", "Tenant ID", "Email", "State", "Created Date");
        }
        catch (Exception e) {
            String message = "Could not list tenants";
            this.printError(message, e);
        }
    }

    public void listAllUsers() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<UserInfoBean>>(){}.getType();
            List userInfoList = (List)this.restClient.listEntity("/api/v4.1/users", listType, "users");
            if (userInfoList == null || userInfoList.size() == 0) {
                System.out.println("No users found");
                return;
            }
            RowMapper<UserInfoBean> rowMapper = new RowMapper<UserInfoBean>(){

                @Override
                public String[] getData(UserInfoBean userInfo) {
                    String[] data = new String[]{userInfo.getUserName(), userInfo.getRole()};
                    return data;
                }
            };
            UserInfoBean[] usersArray = new UserInfoBean[userInfoList.size()];
            usersArray = userInfoList.toArray(usersArray);
            System.out.println("Users:");
            CliUtils.printTable(usersArray, rowMapper, "Username", "Role");
        }
        catch (Exception e) {
            String message = "Could not list users";
            this.printError(message, e);
        }
    }

    public void addCartridge(String cartridgeDefinition) throws CommandException {
        this.restClient.deployEntity("/api/v4.1/cartridges", cartridgeDefinition, "cartridge");
    }

    public void updateCartridge(String cartridgeDefinition) throws CommandException {
        this.restClient.updateEntity("/api/v4.1/cartridges", cartridgeDefinition, "cartridge");
    }

    public void undeployCartrigdeDefinition(String cartridgeId) throws CommandException {
        this.restClient.undeployEntity(ENDPOINT_UNDEPLOY_CARTRIDGE, "cartridge", cartridgeId);
    }

    public void addAutoscalingPolicy(String autoScalingPolicy) throws CommandException {
        this.restClient.deployEntity("/api/v4.1/autoscalingPolicies", autoScalingPolicy, "autoscaling policy");
    }

    public void updateAutoscalingPolicy(String autoScalingPolicy) throws CommandException {
        this.restClient.updateEntity("/api/v4.1/autoscalingPolicies", autoScalingPolicy, "autoscaling policy");
    }

    public void listApplications() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<ApplicationBean>>(){}.getType();
            List list = (List)this.restClient.listEntity("/api/v4.1/applications", listType, "applications");
            if (list == null || list.size() == 0) {
                System.out.println("No applications found");
                return;
            }
            RowMapper<ApplicationBean> rowMapper = new RowMapper<ApplicationBean>(){

                @Override
                public String[] getData(ApplicationBean applicationDefinition) {
                    String[] data = new String[]{applicationDefinition.getApplicationId(), applicationDefinition.getAlias(), applicationDefinition.getStatus()};
                    return data;
                }
            };
            ApplicationBean[] array = new ApplicationBean[list.size()];
            array = list.toArray(array);
            System.out.println("Applications found:");
            CliUtils.printTable(array, rowMapper, "Application ID", "Alias", "Status");
        }
        catch (Exception e) {
            String message = "Could not list applications";
            this.printError(message, e);
        }
    }

    public void listAutoscalingPolicies() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<AutoscalePolicyBean>>(){}.getType();
            List list = (List)this.restClient.listEntity("/api/v4.1/autoscalingPolicies", listType, "autoscaling policies");
            if (list == null || list.size() == 0) {
                System.out.println("No autoscaling policies found");
                return;
            }
            RowMapper<AutoscalePolicyBean> rowMapper = new RowMapper<AutoscalePolicyBean>(){

                @Override
                public String[] getData(AutoscalePolicyBean policy) {
                    String[] data = new String[]{policy.getId(), String.valueOf(policy.getLoadThresholds().getRequestsInFlight().getThreshold()), String.valueOf(policy.getLoadThresholds().getMemoryConsumption().getThreshold()), String.valueOf(policy.getLoadThresholds().getLoadAverage().getThreshold())};
                    return data;
                }
            };
            AutoscalePolicyBean[] array = new AutoscalePolicyBean[list.size()];
            array = list.toArray(array);
            System.out.println("Autoscaling policies found:");
            CliUtils.printTable(array, rowMapper, "ID", "Requests In Flight Threshold", "Memory Consumption Threshold", "Load Average Threshold");
        }
        catch (Exception e) {
            String message = "Could not list autoscaling policies";
            this.printError(message, e);
        }
    }

    public void describeDeploymentPolicy(String deploymentPolicyId) throws CommandException {
        try {
            DeploymentPolicyBean policy = (DeploymentPolicyBean)this.restClient.getEntity(ENDPOINT_GET_DEPLOYMENT_POLICY, DeploymentPolicyBean.class, "{deploymentPolicyId}", deploymentPolicyId, "deployment policy");
            if (policy == null) {
                System.out.println("Deployment policy not found: " + deploymentPolicyId);
                return;
            }
            System.out.println("Deployment policy: " + deploymentPolicyId);
            System.out.println(this.getGson().toJson((Object)policy));
        }
        catch (Exception e) {
            String message = "Error in describing deployment policy: " + deploymentPolicyId;
            this.printError(message, e);
        }
    }

    public void describeApplicationPolicy(String applicationPolicyId) throws CommandException {
        try {
            ApplicationPolicyBean policy = (ApplicationPolicyBean)this.restClient.getEntity(ENDPOINT_GET_APPLICATION_POLICY, ApplicationPolicyBean.class, "{applicationPolicyId}", applicationPolicyId, "application policy");
            if (policy == null) {
                System.out.println("Application policy not found: " + applicationPolicyId);
                return;
            }
            System.out.println("Application policy: " + applicationPolicyId);
            System.out.println(this.getGson().toJson((Object)policy));
        }
        catch (Exception e) {
            String message = "Error in describing application policy: " + applicationPolicyId;
            this.printError(message, e);
        }
    }

    public void describeAutoScalingPolicy(String autoscalingPolicyId) throws CommandException {
        try {
            AutoscalePolicyBean policy = (AutoscalePolicyBean)this.restClient.getEntity(ENDPOINT_GET_AUTOSCALING_POLICY, AutoscalePolicyBean.class, "{id}", autoscalingPolicyId, "autoscaling policy");
            if (policy == null) {
                System.out.println("Autoscaling policy not found: " + autoscalingPolicyId);
                return;
            }
            System.out.println("Autoscaling policy: " + autoscalingPolicyId);
            System.out.println(this.getGson().toJson((Object)policy));
        }
        catch (Exception e) {
            String message = "Could not describe autoscaling policy: " + autoscalingPolicyId;
            this.printError(message, e);
        }
    }

    public void addKubernetesCluster(String entityBody) throws CommandException {
        this.restClient.deployEntity("/api/v4.1/kubernetesClusters", entityBody, "kubernetes cluster");
    }

    public void listKubernetesClusters() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<KubernetesClusterBean>>(){}.getType();
            List list = (List)this.restClient.listEntity("/api/v4.1/kubernetesClusters", listType, "kubernetes cluster");
            if (list != null && list.size() > 0) {
                RowMapper<KubernetesClusterBean> partitionMapper = new RowMapper<KubernetesClusterBean>(){

                    @Override
                    public String[] getData(KubernetesClusterBean kubernetesCluster) {
                        String[] data = new String[]{kubernetesCluster.getClusterId(), kubernetesCluster.getDescription()};
                        return data;
                    }
                };
                KubernetesClusterBean[] array = new KubernetesClusterBean[list.size()];
                array = list.toArray(array);
                System.out.println("Kubernetes clusters found:");
                CliUtils.printTable(array, partitionMapper, "Group ID", "Description");
            } else {
                System.out.println("No Kubernetes clusters found");
            }
        }
        catch (Exception e) {
            String message = "Could not list Kubernetes clusters";
            this.printError(message, e);
        }
    }

    public void undeployKubernetesCluster(String clusterId) throws CommandException {
        this.restClient.undeployEntity(ENDPOINT_UNDEPLOY_KUBERNETES_CLUSTER, "kubernetes cluster", clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKubernetesHost(String entityBody, String clusterId) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + ENDPOINT_DEPLOY_KUBERNETES_HOST.replace("{kubernetesClusterId}", clusterId), entityBody);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200") || responseCode.equals("201")) {
                System.out.println("You have successfully deployed host to Kubernetes cluster: " + clusterId);
            } else {
                String resultString = CliUtils.getHttpResponseString(response);
                ExceptionMapper exception = (ExceptionMapper)gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
            }
        }
        catch (Exception e) {
            String message = "Could not add host to Kubernetes cluster: " + clusterId;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public void listKubernetesHosts(String clusterId) throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<KubernetesHostBean>>(){}.getType();
            List list = (List)this.restClient.listEntity(ENDPOINT_LIST_KUBERNETES_HOSTS.replace("{kubernetesClusterId}", clusterId), listType, "kubernetes host");
            if (list != null && list.size() > 0) {
                RowMapper<KubernetesHostBean> partitionMapper = new RowMapper<KubernetesHostBean>(){

                    @Override
                    public String[] getData(KubernetesHostBean kubernetesHost) {
                        String[] data = new String[]{kubernetesHost.getHostId(), kubernetesHost.getHostname(), RestCommandLineService.this.emptyStringIfNullOrEmpty(kubernetesHost.getPrivateIPAddress()), RestCommandLineService.this.emptyStringIfNullOrEmpty(kubernetesHost.getPublicIPAddress())};
                        return data;
                    }
                };
                KubernetesHostBean[] array = new KubernetesHostBean[list.size()];
                array = list.toArray(array);
                System.out.println("Kubernetes hosts found:");
                CliUtils.printTable(array, partitionMapper, "Host ID", "Hostname", "Private IP Address", "Public IP Address");
            } else {
                System.out.println("No kubernetes hosts found");
            }
        }
        catch (Exception e) {
            String message = "Could not list kubernetes hosts";
            this.printError(message, e);
        }
    }

    private String emptyStringIfNullOrEmpty(String value) {
        return StringUtils.isBlank((CharSequence)value) ? "" : value;
    }

    public void getKubernetesMaster(String clusterId) throws CommandException {
        try {
            Type listType = new TypeToken<KubernetesMasterBean>(){}.getType();
            KubernetesMasterBean master = (KubernetesMasterBean)this.restClient.getEntity("/api/v4.1/kubernetesClusters/{kubernetesClusterId}/master", KubernetesMasterBean.class, "{kubernetesClusterId}", clusterId, "network partition");
            if (master == null) {
                System.out.println("Kubernetes master not found in: " + clusterId);
                return;
            }
            System.out.println("Cluster: " + clusterId);
            System.out.println(this.getGson().toJson((Object)master));
        }
        catch (Exception e) {
            String message = "Could not get the master of " + clusterId;
            this.printError(message, e);
        }
    }

    public void describeKubernetesCluster(String clusterId) throws CommandException {
        try {
            Type listType = new TypeToken<KubernetesClusterBean>(){}.getType();
            KubernetesClusterBean cluster = (KubernetesClusterBean)this.restClient.getEntity(ENDPOINT_GET_KUBERNETES_HOST_CLUSTER, KubernetesClusterBean.class, "{kubernetesClusterId}", clusterId, "kubernetes cluster");
            if (cluster == null) {
                System.out.println("Kubernetes cluster not found: " + clusterId);
                return;
            }
            System.out.println("Kubernetes cluster: " + clusterId);
            System.out.println(this.getGson().toJson((Object)cluster));
        }
        catch (Exception e) {
            String message = "Could not describe Kubernetes cluster: " + clusterId;
            this.printError(message, e);
        }
    }

    public void addDomainMappings(String applicationId, String resourceFileContent) throws CommandException {
        String endpoint = ENDPOINT_DOMAIN_MAPPINGS.replace("{applicationId}", applicationId);
        this.restClient.deployEntity(endpoint, resourceFileContent, "domain mappings");
    }

    public void listDomainMappings(String applicationId) throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<DomainMappingBean>>(){}.getType();
            List list = (List)this.restClient.listEntity(ENDPOINT_DOMAIN_MAPPINGS.replace("{applicationId}", applicationId), listType, "domain mappings");
            if (list == null) {
                System.out.println("No domain mappings found in application: " + applicationId);
                return;
            }
            RowMapper<DomainMappingBean> rowMapper = new RowMapper<DomainMappingBean>(){

                @Override
                public String[] getData(DomainMappingBean domainMappingBean) {
                    String[] data = new String[]{domainMappingBean.getDomainName(), domainMappingBean.getContextPath()};
                    return data;
                }
            };
            DomainMappingBean[] array = new DomainMappingBean[list.size()];
            array = list.toArray(array);
            System.out.println("Domain mappings found in application: " + applicationId);
            CliUtils.printTable(array, rowMapper, "Domain Name", "Context Path");
        }
        catch (Exception e) {
            String message = "Could not list domain mappings in application: " + applicationId;
            this.printError(message, e);
        }
    }

    public void removeDomainMappings(String applicationId, String domainName) throws CommandException {
        String endpoint = ENDPOINT_REMOVE_DOMAIN_MAPPINGS.replace("{applicationId}", applicationId).replace("{domainName}", domainName);
        this.restClient.undeployEntity(endpoint, "domain mappings", applicationId);
    }

    public void undeployKubernetesHost(String clusterId, String hostId) throws CommandException {
        this.restClient.undeployEntity(ENDPOINT_UNDEPLOY_KUBERNETES_HOST.replace("{kubernetesClusterId}", clusterId), "kubernetes host", hostId);
    }

    public void updateKubernetesMaster(String entityBody, String clusterId) throws CommandException {
        this.restClient.updateEntity("/api/v4.1/kubernetesClusters/{kubernetesClusterId}/master".replace("{kubernetesClusterId}", clusterId), entityBody, "kubernetes master");
    }

    public void updateKubernetesHost(String entityBody) throws CommandException {
        this.restClient.updateEntity(ENDPOINT_UPDATE_KUBERNETES_HOST, entityBody, "kubernetes host");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeArtifacts(String cartridgeAlias) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + ENDPOINT_SYNCHRONIZE_ARTIFACTS.replace("{subscriptionAlias}", cartridgeAlias), cartridgeAlias);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            if (responseCode.equals("200")) {
                System.out.println(String.format("Synchronizing artifacts for cartridge subscription alias: %s", cartridgeAlias));
            } else {
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                String resultString = CliUtils.getHttpResponseString(response);
                ExceptionMapper exception = (ExceptionMapper)gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
            }
        }
        catch (Exception e) {
            String message = "Could not synchronize artifacts for cartridge subscription alias: " + cartridgeAlias;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public void addCartridgeGroup(String entityBody) throws CommandException {
        this.restClient.deployEntity("/api/v4.1/cartridgeGroups", entityBody, "cartridge group");
    }

    public void undeployServiceGroup(String groupDefinitionName) throws CommandException {
        this.restClient.undeployEntity(ENDPOINT_UNDEPLOY_SERVICE_GROUP, "cartridge group", groupDefinitionName);
    }

    public void describeServiceGroup(String groupDefinitionName) throws CommandException {
        try {
            CartridgeGroupBean bean = (CartridgeGroupBean)this.restClient.listEntity(ENDPOINT_LIST_SERVICE_GROUP.replace("{groupDefinitionName}", groupDefinitionName), CartridgeGroupBean.class, "serviceGroup");
            if (bean == null) {
                System.out.println("Cartridge group not found: " + groupDefinitionName);
                return;
            }
            System.out.println("Service Group : " + groupDefinitionName);
            System.out.println(this.getGson().toJson((Object)bean));
        }
        catch (Exception e) {
            String message = "Could not describe cartridge group: " + groupDefinitionName;
            this.printError(message, e);
        }
    }

    public void addApplication(String entityBody) throws CommandException {
        this.restClient.deployEntity("/api/v4.1/applications", entityBody, "application");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployApplication(String applicationId, String applicationPolicyId) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            String url = ENDPOINT_DEPLOY_APPLICATION.replace("{applicationId}", applicationId).replace("{applicationPolicyId}", applicationPolicyId);
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + url, "");
            String result = CliUtils.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            System.out.println(((ResponseMessageBean)gson.fromJson(result, ResponseMessageBean.class)).getMessage());
        }
        catch (Exception e) {
            String message = "Could not deploy application: " + applicationId;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployApplication(String applicationId) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + ENDPOINT_UNDEPLOY_APPLICATION.replace("{id}", applicationId), "");
            String result = CliUtils.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            System.out.println(((ResponseMessageBean)gson.fromJson(result, ResponseMessageBean.class)).getMessage());
        }
        catch (Exception e) {
            String message = "Could not undeploy application: " + applicationId;
            this.printError(message, e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public void deleteApplication(String applicationId) throws CommandException {
        this.restClient.deleteEntity("/api/v4.1/applications/{appId}".replace("{appId}", applicationId), applicationId, "application");
    }

    public void updateApplication(String entityBody) throws CommandException {
        this.restClient.updateEntity("/api/v4.1/applications", entityBody, "application");
    }

    public void deleteAutoSclaingPolicy(String autoscalingPolicyId) throws CommandException {
        this.restClient.deleteEntity(ENDPOINT_REMOVE_AUTOSCALINGPOLICY.replace("{policyId}", autoscalingPolicyId), autoscalingPolicyId, "Auto-scaling policy");
    }

    public void describeApplication(String applicationId) throws CommandException {
        try {
            ApplicationBean application = (ApplicationBean)this.restClient.getEntity("/api/v4.1/applications/{appId}", ApplicationBean.class, "{appId}", applicationId, "application");
            if (application == null) {
                System.out.println("Application not found: " + applicationId);
                return;
            }
            System.out.println("Application: " + applicationId);
            System.out.println(this.getGson().toJson((Object)application));
        }
        catch (Exception e) {
            String message = "Could not describe application: " + applicationId;
            this.printError(message, e);
        }
    }

    public void describeApplicationRuntime(String applicationId) throws CommandException {
        try {
            ApplicationBean application = (ApplicationBean)this.restClient.getEntity(ENDPOINT_GET_APPLICATION_RUNTIME, ApplicationBean.class, "{applicationId}", applicationId, "application");
            if (application == null) {
                System.out.println("Application Runtime not found: " + applicationId);
                return;
            }
            System.out.println("Application: " + applicationId);
            System.out.println(this.getGson().toJson((Object)application));
        }
        catch (Exception e) {
            String message = "Could not describe application runtime: " + applicationId;
            this.printError(message, e);
        }
    }

    public void addApplicationSignup(String entityBody, String applicationId) throws CommandException {
        this.restClient.deployEntity(ENDPOINT_APPLICATION_SIGNUP.replace("{applicationId}", applicationId), entityBody, "application signup");
    }

    public void describeApplicationSignup(String applicationId) throws CommandException {
        try {
            ApplicationSignUpBean bean = (ApplicationSignUpBean)this.restClient.listEntity(ENDPOINT_APPLICATION_SIGNUP.replace("{applicationId}", applicationId), ApplicationSignUpBean.class, "applicationSignup");
            if (bean == null) {
                System.out.println("Application sign up not found for application: " + applicationId);
                return;
            }
            System.out.println("Application signup for application : " + applicationId);
            System.out.println(this.getGson().toJson((Object)bean));
        }
        catch (Exception e) {
            String message = "Could not describe application signup for application: " + applicationId;
            this.printError(message, e);
        }
    }

    public void deleteApplicationSignup(String applicationId) throws CommandException {
        this.restClient.deleteEntity(ENDPOINT_APPLICATION_SIGNUP.replace("{applicationId}", applicationId), applicationId, "application signup");
    }

    private void handleException(String key, Exception e, Object ... args) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Displaying message for {}. Exception thrown is {}", (Object)key, e.getClass());
        }
        String message = CliUtils.getMessage(key, args);
        log.error(message);
        System.out.println(message);
        throw new CommandException(message, e);
    }

    private void printError(String message, Throwable e) {
        System.out.println(message);
        log.error(message, e);
    }

    public void addNetworkPartition(String networkPartitionDefinition) throws CommandException {
        this.restClient.deployEntity("/api/v4.1/networkPartitions", networkPartitionDefinition, "network partition");
    }

    public void removeNetworkPartition(String networkPartitionId) throws CommandException {
        this.restClient.deleteEntity(ENDPOINT_REMOVE_NETWORK_PARTITION.replace("{id}", networkPartitionId), networkPartitionId, "network-partition");
    }

    public void listNetworkPartitions() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<NetworkPartitionBean>>(){}.getType();
            List networkPartitionsList = (List)this.restClient.listEntity("/api/v4.1/networkPartitions", listType, "network-partitions");
            if (networkPartitionsList == null || networkPartitionsList.size() == 0) {
                System.out.println("No network partitions found");
                return;
            }
            RowMapper<NetworkPartitionBean> networkPartitionMapper = new RowMapper<NetworkPartitionBean>(){

                @Override
                public String[] getData(NetworkPartitionBean partition) {
                    String[] data = new String[]{partition.getId(), String.valueOf(partition.getPartitions().size())};
                    return data;
                }
            };
            NetworkPartitionBean[] partitions = new NetworkPartitionBean[networkPartitionsList.size()];
            partitions = networkPartitionsList.toArray(partitions);
            System.out.println("Network partitions found:");
            CliUtils.printTable(partitions, networkPartitionMapper, "Network Partition ID", "Number of Partitions");
        }
        catch (Exception e) {
            String message = "Error in listing network partitions";
            this.printError(message, e);
        }
    }

    public void updateNetworkPartition(String networkPartitionDefinition) throws CommandException {
        this.restClient.updateEntity("/api/v4.1/networkPartitions", networkPartitionDefinition, "network-partition");
    }

    public void describeNetworkPartition(String partitionId) throws CommandException {
        try {
            NetworkPartitionBean partition = (NetworkPartitionBean)this.restClient.getEntity(ENDPOINT_GET_NETWORK_PARTITION, NetworkPartitionBean.class, "{networkPartitionId}", partitionId, "network partition");
            if (partition == null) {
                System.out.println("Network partition not found: " + partitionId);
                return;
            }
            System.out.println("Partition: " + partitionId);
            System.out.println(this.getGson().toJson((Object)partition));
        }
        catch (Exception e) {
            String message = "Could not describe partition: " + partitionId;
            this.printError(message, e);
        }
    }

    public void addDeploymentPolicy(String deploymentPolicy) throws CommandException {
        this.restClient.deployEntity("/api/v4.1/deploymentPolicies", deploymentPolicy, "deployment policy");
    }

    public void addApplicationPolicy(String applicationPolicy) throws CommandException {
        this.restClient.deployEntity("/api/v4.1/applicationPolicies", applicationPolicy, "application policy");
    }

    public void updateDeploymentPolicy(String deploymentPolicy) throws CommandException {
        this.restClient.updateEntity("/api/v4.1/deploymentPolicies", deploymentPolicy, "deployment policy");
    }

    public void deleteDeploymentPolicy(String deploymentPolicyId) throws CommandException {
        this.restClient.deleteEntity(ENDPOINT_REMOVE_DEPLOYMENT_POLICY.replace("{policyId}", deploymentPolicyId), deploymentPolicyId, "deployment policy");
    }

    public void listDeploymentPolicies() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<DeploymentPolicyBean>>(){}.getType();
            List list = (List)this.restClient.listEntity("/api/v4.1/deploymentPolicies", listType, "deployment policies");
            if (list == null || list.size() == 0) {
                System.out.println("No deployment policies found");
                return;
            }
            RowMapper<DeploymentPolicyBean> rowMapper = new RowMapper<DeploymentPolicyBean>(){

                @Override
                public String[] getData(DeploymentPolicyBean policy) {
                    String[] data = new String[]{policy.getId(), String.valueOf(policy.getNetworkPartitions().size())};
                    return data;
                }
            };
            DeploymentPolicyBean[] array = new DeploymentPolicyBean[list.size()];
            array = list.toArray(array);
            System.out.println("Deployment policies found:");
            CliUtils.printTable(array, rowMapper, "ID", "Accessibility");
        }
        catch (Exception e) {
            String message = "Could not list deployment policies";
            this.printError(message, e);
        }
    }

    public void listApplicationPolicies() throws CommandException {
        try {
            Type listType = new TypeToken<ArrayList<ApplicationPolicyBean>>(){}.getType();
            List list = (List)this.restClient.listEntity("/api/v4.1/applicationPolicies", listType, "application policies");
            if (list == null || list.size() == 0) {
                System.out.println("No application policies found");
                return;
            }
            RowMapper<ApplicationPolicyBean> rowMapper = new RowMapper<ApplicationPolicyBean>(){

                @Override
                public String[] getData(ApplicationPolicyBean policy) {
                    String[] data = new String[]{policy.getId(), String.valueOf(policy.getNetworkPartitions().length), policy.getAlgorithm()};
                    return data;
                }
            };
            ApplicationPolicyBean[] array = new ApplicationPolicyBean[list.size()];
            array = list.toArray(array);
            System.out.println("Application policies found:");
            CliUtils.printTable(array, rowMapper, "ID", "No of network partitions", "algorithm");
        }
        catch (Exception e) {
            String message = "Could not list application policies";
            this.printError(message, e);
        }
    }

    public void deleteApplicationPolicy(String applicationPolicyId) throws CommandException {
        this.restClient.deleteEntity(ENDPOINT_REMOVE_APPLICATION_POLICY.replace("{policyId}", applicationPolicyId), applicationPolicyId, "application policy");
    }

    public void updateApplicationPolicy(String applicationPolicy) throws CommandException {
        this.restClient.updateEntity("/api/v4.1/applicationPolicies", applicationPolicy, "application policy");
    }

    private static class SingletonHolder {
        private static final RestCommandLineService INSTANCE = new RestCommandLineService();

        private SingletonHolder() {
        }
    }
}

