/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDomainMappingsCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(AddDomainMappingsCommand.class);
    private Options options = new Options();

    public AddDomainMappingsCommand() {
        Option option = new Option("p", "resource-path", true, "Domain mappings resource path");
        option.setArgName("resource path");
        this.options.addOption(option);
    }

    @Override
    public String getName() {
        return "add-domain-mappings";
    }

    @Override
    public String getDescription() {
        return "Add domain mappings";
    }

    @Override
    public String getArgumentSyntax() {
        return "[application-id]";
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing command: ", (Object)this.getName());
        }
        if (args == null || args.length <= 0) {
            context.getStratosApplication().printUsage(this.getName());
            return 1;
        }
        try {
            GnuParser parser = new GnuParser();
            CommandLine commandLine = parser.parse(this.options, args);
            Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
            if (opts.hasOption("p")) {
                String resourcePath = opts.getOption("p").getValue();
                if (resourcePath == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                String applicationId = args[0];
                if (applicationId != null) {
                    String resourceFileContent = CliUtils.readResource(resourcePath);
                    RestCommandLineService.getInstance().addDomainMappings(applicationId, resourceFileContent);
                    return 0;
                }
                context.getStratosApplication().printUsage(this.getName());
                return 1;
            }
            context.getStratosApplication().printUsage(this.getName());
            return 1;
        }
        catch (ParseException e) {
            log.error("Error parsing arguments", (Throwable)e);
            System.out.println(e.getMessage());
            return 1;
        }
        catch (IOException e) {
            System.out.println("Invalid resource path");
            return 1;
        }
        catch (Exception e) {
            String message = "Unknown error occurred: " + e.getMessage();
            System.out.println(message);
            log.error(message, (Throwable)e);
            return 1;
        }
    }
}

