/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteApplicationSignupCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(DeleteApplicationSignupCommand.class);

    @Override
    public String getName() {
        return "remove-application-signup";
    }

    @Override
    public String getDescription() {
        return "Remove Application Signup";
    }

    @Override
    public String getArgumentSyntax() {
        return "[application-id]";
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 1) {
            String applicationId = args[0];
            if (log.isDebugEnabled()) {
                log.debug("Getting delete application id {}", (Object)applicationId);
            }
            RestCommandLineService.getInstance().deleteApplicationSignup(applicationId);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

