/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.commands.DescribeAutoScalingPolicyCommand;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribeTenantCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(DescribeAutoScalingPolicyCommand.class);

    @Override
    public String getName() {
        return "describe-tenant";
    }

    @Override
    public String getDescription() {
        return "Describe tenant";
    }

    @Override
    public String getArgumentSyntax() {
        return "[Domain-Name]";
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 1) {
            String domainName = args[0];
            if (log.isDebugEnabled()) {
                log.debug("Getting tenant info {}", (Object)domainName);
            }
            RestCommandLineService.getInstance().describeTenant(domainName);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

