/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveCartridgeGroupCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(RemoveCartridgeGroupCommand.class);

    @Override
    public String getName() {
        return "remove-cartridge-group";
    }

    @Override
    public String getDescription() {
        return "Remove cartridge group";
    }

    @Override
    public String getArgumentSyntax() {
        return "[cartridge-group-name]";
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing command: ", (Object)this.getName());
        }
        if (args == null || args.length <= 0) {
            context.getStratosApplication().printUsage(this.getName());
            return 1;
        }
        String cartridgeGroupName = args[0];
        RestCommandLineService.getInstance().undeployServiceGroup(cartridgeGroupName);
        return 0;
    }
}

