/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDomainMappingCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(RemoveDomainMappingCommand.class);
    private Options options = new Options();

    public RemoveDomainMappingCommand() {
        Option applicationIdOption = new Option("a", "application-id", true, "Application Id");
        applicationIdOption.setArgName("application id");
        Option domainNameOption = new Option("d", "domain-name", true, "Domain name");
        domainNameOption.setArgName("domain name");
        this.options.addOption(applicationIdOption);
        this.options.addOption(domainNameOption);
    }

    @Override
    public String getName() {
        return "remove-domain-mapping";
    }

    @Override
    public String getDescription() {
        return "Remove domain mapping";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing command: ", (Object)this.getName());
        }
        if (args == null || args.length <= 0) {
            context.getStratosApplication().printUsage(this.getName());
            return 1;
        }
        try {
            GnuParser parser = new GnuParser();
            CommandLine commandLine = parser.parse(this.options, args);
            Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
            if (opts.hasOption("a") && opts.hasOption("d")) {
                String applicationId = opts.getOption("a").getValue();
                if (applicationId == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                String domainName = opts.getOption("d").getValue();
                if (domainName == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                RestCommandLineService.getInstance().removeDomainMappings(applicationId, domainName);
                return 0;
            }
            context.getStratosApplication().printUsage(this.getName());
            return 1;
        }
        catch (ParseException e) {
            log.error("Error parsing arguments", (Throwable)e);
            System.out.println(e.getMessage());
            return 1;
        }
        catch (Exception e) {
            String message = "Unknown error occurred: " + e.getMessage();
            System.out.println(message);
            log.error(message, (Throwable)e);
            return 1;
        }
    }
}

