/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTenantCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(UpdateTenantCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option userNameOption = new Option("u", "username", true, "Tenant user name");
        userNameOption.setArgName("username");
        options.addOption(userNameOption);
        Option firstNameOption = new Option("f", "first-name", true, "Tenant first name");
        firstNameOption.setArgName("firstname");
        options.addOption(firstNameOption);
        Option lastNameOption = new Option("l", "last-name", true, "Tenant last name");
        lastNameOption.setArgName("lastname");
        options.addOption(lastNameOption);
        Option passwordOption = new Option("p", "password", true, "Tenant password");
        passwordOption.setArgName("password");
        options.addOption(passwordOption);
        Option domainOption = new Option("d", "domain-name", true, "Tenant domain");
        domainOption.setArgName("domain");
        options.addOption(domainOption);
        Option emailOption = new Option("e", "email", true, "Tenant email");
        emailOption.setArgName("email");
        options.addOption(emailOption);
        Option idOption = new Option("i", "tenant-id", true, "Tenant id");
        emailOption.setArgName("id");
        options.addOption(idOption);
        return options;
    }

    @Override
    public String getName() {
        return "update-tenant";
    }

    @Override
    public String getDescription() {
        return "Update an existing tenant";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String admin = null;
            String firstName = null;
            String lastName = null;
            String password = null;
            String domain = null;
            String email = null;
            int id = 0;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
                if (log.isDebugEnabled()) {
                    log.debug("Update tenant");
                }
                if (opts.hasOption("u")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Username option is passed");
                    }
                    admin = opts.getOption("u").getValue();
                }
                if (opts.hasOption("f")) {
                    if (log.isTraceEnabled()) {
                        log.trace("First name option is passed");
                    }
                    firstName = opts.getOption("f").getValue();
                }
                if (opts.hasOption("l")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Last name option is passed");
                    }
                    lastName = opts.getOption("l").getValue();
                }
                if (opts.hasOption("p")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Password option is passed");
                    }
                    password = opts.getOption("p").getValue();
                }
                if (opts.hasOption("d")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Domain name option is passed");
                    }
                    domain = opts.getOption("d").getValue();
                }
                if (opts.hasOption("e")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Email option is passed");
                    }
                    email = opts.getOption("e").getValue();
                }
                if (opts.hasOption("i")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Id option is passed");
                    }
                    id = Integer.parseInt(opts.getOption("i").getValue());
                }
                if (id == 0 || admin == null || firstName == null || lastName == null || password == null || domain == null || email == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                RestCommandLineService.getInstance().updateTenant(id, admin, firstName, lastName, password, domain, email);
                return 0;
            }
            catch (ParseException e) {
                log.error("Error parsing arguments", (Throwable)e);
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

