/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateUserCommand
implements Command<StratosCommandContext> {
    private static final Logger log = LoggerFactory.getLogger(UpdateUserCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option userNameOption = new Option("u", "username", true, "Username");
        userNameOption.setArgName("username");
        options.addOption(userNameOption);
        Option passwordOption = new Option("p", "password", true, "User credential");
        passwordOption.setArgName("credential");
        options.addOption(passwordOption);
        Option roleOption = new Option("r", "role-name", true, "User role");
        roleOption.setArgName("role");
        options.addOption(roleOption);
        Option firstNameOption = new Option("f", "first-name", true, "User first name");
        firstNameOption.setArgName("firstName");
        options.addOption(firstNameOption);
        Option lastNameOption = new Option("l", "last-name", true, "User last name");
        lastNameOption.setArgName("lastName");
        options.addOption(lastNameOption);
        Option emailOption = new Option("e", "email", true, "User email");
        emailOption.setArgName("email");
        options.addOption(emailOption);
        Option profileNameOption = new Option("pr", "profile-name", true, "Profile name");
        profileNameOption.setArgName("profileName");
        options.addOption(profileNameOption);
        return options;
    }

    @Override
    public String getName() {
        return "update-user";
    }

    @Override
    public String getDescription() {
        return "Update an existing user";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args, Option[] alreadyParsedOpts) throws CommandException {
        if (log.isDebugEnabled()) {
            log.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String userName = null;
            String credential = null;
            String role = null;
            String firstName = null;
            String lastName = null;
            String email = null;
            String profileName = null;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                Options opts = CliUtils.mergeOptionArrays(alreadyParsedOpts, commandLine.getOptions());
                if (log.isDebugEnabled()) {
                    log.debug("Update user");
                }
                if (opts.hasOption("u")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Username option is passed");
                    }
                    userName = opts.getOption("u").getValue();
                }
                if (opts.hasOption("p")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Credential option is passed");
                    }
                    credential = opts.getOption("p").getValue();
                }
                if (opts.hasOption("r")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Role option is passed");
                    }
                    role = opts.getOption("r").getValue();
                }
                if (opts.hasOption("f")) {
                    if (log.isTraceEnabled()) {
                        log.trace("First name option is passed");
                    }
                    firstName = opts.getOption("f").getValue();
                }
                if (opts.hasOption("l")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Last name option is passed");
                    }
                    lastName = opts.getOption("l").getValue();
                }
                if (opts.hasOption("e")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Email option is passed");
                    }
                    email = opts.getOption("e").getValue();
                }
                if (opts.hasOption("pr")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Profile name option is passed");
                    }
                    profileName = opts.getOption("pr").getValue();
                }
                if (userName == null || credential == null || role == null || firstName == null || lastName == null || email == null) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                RestCommandLineService.getInstance().updateUser(userName, credential, role, firstName, lastName, email, profileName);
                return 0;
            }
            catch (ParseException e) {
                log.error("Error parsing arguments", (Throwable)e);
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

