/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.kubernetes.client;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.kubernetes.client.exceptions.KubernetesClientException;
import org.apache.stratos.kubernetes.client.interfaces.KubernetesAPIClientInterface;

public class KubernetesApiClient
implements KubernetesAPIClientInterface {
    private static final Log log = LogFactory.getLog(KubernetesApiClient.class);
    private KubernetesClient kubernetesClient;

    public KubernetesApiClient(String endpointUrl) {
        this.kubernetesClient = new KubernetesClient(endpointUrl);
    }

    @Override
    public void createPod(String podId, String podName, Map<String, String> podLabels, Map<String, String> annotations, String dockerImage, String cpu, String memory, List<ContainerPort> ports, List<EnvVar> environmentVariables) throws KubernetesClientException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Creating kubernetes pod: [pod-id] %s [pod-name] %s [docker-image] %s [cpu] %s [memory] %s [ports] %s", podId, podLabels, dockerImage, cpu, memory, ports));
            }
            Pod pod = new Pod();
            pod.setApiVersion(Pod.ApiVersion.V_1);
            pod.setKind("Pod");
            pod.setSpec(new PodSpec());
            pod.setMetadata(new ObjectMeta());
            pod.getMetadata().setName(podId);
            pod.getMetadata().setLabels(podLabels);
            pod.getMetadata().setAnnotations(annotations);
            Container containerTemplate = new Container();
            containerTemplate.setName(podName);
            containerTemplate.setImage(dockerImage);
            containerTemplate.setEnv(environmentVariables);
            ArrayList<Container> containerTemplates = new ArrayList<Container>();
            containerTemplates.add(containerTemplate);
            pod.getSpec().setContainers(containerTemplates);
            ResourceRequirements resources = new ResourceRequirements();
            HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
            limits.put("cpu", new Quantity(cpu));
            limits.put("memory", new Quantity(memory));
            resources.setLimits(limits);
            containerTemplate.setResources(resources);
            containerTemplate.setPorts(ports);
            containerTemplate.setImagePullPolicy("IfNotPresent");
            if (environmentVariables != null) {
                containerTemplate.setEnv(environmentVariables);
            }
            this.kubernetesClient.createPod(pod);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Kubernetes pod created successfully: [pod-id] %s", podId));
            }
        }
        catch (Exception e) {
            String msg = String.format("Could not create kubernetes pod: [pod-id] %s", podId);
            log.error((Object)msg, (Throwable)e);
            throw new KubernetesClientException(msg, e);
        }
    }

    @Override
    public Pod getPod(String podId) throws KubernetesClientException {
        try {
            return this.kubernetesClient.getPod(podId);
        }
        catch (Exception e) {
            String msg = String.format("Could not retrieve kubernetes pod: [pod-id] %s", podId);
            log.error((Object)msg, (Throwable)e);
            throw new KubernetesClientException(msg, e);
        }
    }

    @Override
    public List<Pod> getPods() throws KubernetesClientException {
        try {
            return this.kubernetesClient.getPods().getItems();
        }
        catch (Exception e) {
            String msg = "Error while retrieving kubernetes pods.";
            log.error((Object)msg, (Throwable)e);
            throw new KubernetesClientException(msg, e);
        }
    }

    @Override
    public void deletePod(String podId) throws KubernetesClientException {
        try {
            this.kubernetesClient.deletePod(podId);
        }
        catch (Exception e) {
            String message = String.format("Could not delete kubernetes pod: [pod-id] %s", podId);
            log.error((Object)message, (Throwable)e);
            throw new KubernetesClientException(message, e);
        }
    }

    @Override
    public void createService(String serviceId, String serviceName, Map<String, String> serviceLabels, Map<String, String> annotations, int servicePort, String serviceType, String containerPortName, int containerPort, String sessionAffinity) throws KubernetesClientException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Creating kubernetes service: [service-id] %s [service-name] %s [service-port] %d [container-port-name] %s [service-type] %s", serviceId, serviceName, servicePort, containerPortName, serviceType));
            }
            Service service = new Service();
            service.setSpec(new ServiceSpec());
            service.setMetadata(new ObjectMeta());
            service.setApiVersion(Service.ApiVersion.V_1);
            service.setKind("Service");
            service.getMetadata().setName(serviceId);
            service.getSpec().setSessionAffinity(sessionAffinity);
            service.getMetadata().setAnnotations(annotations);
            if (serviceType.equals("NodePort")) {
                service.getSpec().setType("NodePort");
            } else {
                service.getSpec().setType("ClusterIP");
            }
            ArrayList<ServicePort> ports = new ArrayList<ServicePort>();
            ServicePort port = new ServicePort();
            port.setName(containerPortName);
            port.setPort(Integer.valueOf(containerPort));
            port.setTargetPort(new IntOrString(Integer.valueOf(containerPort)));
            if (serviceType.equals("NodePort")) {
                port.setNodePort(Integer.valueOf(servicePort));
            }
            ports.add(port);
            service.getSpec().setPorts(ports);
            service.getMetadata().setLabels(serviceLabels);
            HashMap<String, String> selector = new HashMap<String, String>();
            selector.put("serviceSelector", serviceName);
            service.getSpec().setSelector(selector);
            this.kubernetesClient.createService(service);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Kubernetes service created successfully: [service-id] %s [service-name] %s [node-port] %d [container-port-name] %s [container-port] %d", serviceId, serviceName, servicePort, containerPortName, containerPort));
            }
        }
        catch (Exception e) {
            String message = String.format("Could not create kubernetes service: [service-id] %s [service-name] %s [node-port] %d [container-port-name] %s [container-port] %d", serviceId, serviceName, servicePort, containerPortName, containerPort);
            log.error((Object)message, (Throwable)e);
            throw new KubernetesClientException(message, e);
        }
    }

    @Override
    public Service getService(String serviceId) throws KubernetesClientException {
        try {
            return this.kubernetesClient.getService(serviceId);
        }
        catch (Exception e) {
            String msg = String.format("Could not retrieve kubernetes service: [service-id] %s", serviceId);
            log.error((Object)msg, (Throwable)e);
            throw new KubernetesClientException(msg, e);
        }
    }

    @Override
    public List<Service> getServices() throws KubernetesClientException {
        try {
            return this.kubernetesClient.getServices().getItems();
        }
        catch (Exception e) {
            String msg = "Could not retrieve kubernetes services";
            log.error((Object)msg, (Throwable)e);
            throw new KubernetesClientException(msg, e);
        }
    }

    @Override
    public void deleteService(String serviceId) throws KubernetesClientException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Deleting kubernetes service: [service-id] %s", serviceId));
            }
            this.kubernetesClient.deleteService(serviceId);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Kubernetes service deleted successfully: [service-id] %s", serviceId));
            }
        }
        catch (Exception e) {
            String msg = String.format("Could not delete kubernetes service: [service-id] %s", serviceId);
            log.error((Object)msg, (Throwable)e);
            throw new KubernetesClientException(msg, e);
        }
    }
}

