/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.NoParameters;
import com.opensymphony.xwork2.interceptor.ParameterNameAware;
import com.opensymphony.xwork2.util.ArrayUtils;
import com.opensymphony.xwork2.util.ClearableValueStack;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.MemberAccessValueStack;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ParametersInterceptor.class);
    boolean ordered = false;
    Set<Pattern> excludeParams = Collections.emptySet();
    Set<Pattern> acceptParams = Collections.emptySet();
    static boolean devMode = false;
    private String acceptedParamNames = "\\w+((\\.\\w+)|(\\[\\d+\\])|(\\(\\d+\\))|(\\['\\w+'\\])|(\\('\\w+'\\)))*";
    private Pattern acceptedPattern = Pattern.compile(this.acceptedParamNames);
    private ValueStackFactory valueStackFactory;
    static final Comparator<String> rbCollator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int l2;
            int l1 = ParametersInterceptor.countOGNLCharacters(s1);
            return l1 < (l2 = ParametersInterceptor.countOGNLCharacters(s2)) ? -1 : (l2 < l1 ? 1 : s1.compareTo(s2));
        }
    };

    @Inject
    public void setValueStackFactory(ValueStackFactory valueStackFactory) {
        this.valueStackFactory = valueStackFactory;
    }

    @Inject(value="devMode")
    public static void setDevMode(String mode) {
        devMode = "true".equals(mode);
    }

    public void setAcceptParamNames(String commaDelim) {
        Collection<String> acceptPatterns = ArrayUtils.asCollection(commaDelim);
        if (acceptPatterns != null) {
            this.acceptParams = new HashSet<Pattern>();
            for (String pattern : acceptPatterns) {
                this.acceptParams.add(Pattern.compile(pattern));
            }
        }
    }

    private static int countOGNLCharacters(String s) {
        int count = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c != '.' && c != '[') continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (!(action instanceof NoParameters)) {
            ActionContext ac = invocation.getInvocationContext();
            Map<String, Object> parameters = this.retrieveParameters(ac);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting params " + this.getParameterLogMap(parameters), new String[0]);
            }
            if (parameters != null) {
                Map<String, Object> contextMap = ac.getContextMap();
                try {
                    ReflectionContextState.setCreatingNullObjects(contextMap, true);
                    ReflectionContextState.setDenyMethodExecution(contextMap, true);
                    ReflectionContextState.setReportingConversionErrors(contextMap, true);
                    ValueStack stack = ac.getValueStack();
                    this.setParameters(action, stack, parameters);
                }
                finally {
                    ReflectionContextState.setCreatingNullObjects(contextMap, false);
                    ReflectionContextState.setDenyMethodExecution(contextMap, false);
                    ReflectionContextState.setReportingConversionErrors(contextMap, false);
                }
            }
        }
        return invocation.invoke();
    }

    protected Map<String, Object> retrieveParameters(ActionContext ac) {
        return ac.getParameters();
    }

    protected void addParametersToContext(ActionContext ac, Map<String, Object> newParams) {
    }

    protected void setParameters(Object action, ValueStack stack, Map<String, Object> parameters) {
        boolean memberAccessStack;
        TreeMap acceptableParameters;
        TreeMap<String, Object> params;
        ParameterNameAware parameterNameAware;
        ParameterNameAware parameterNameAware2 = parameterNameAware = action instanceof ParameterNameAware ? (ParameterNameAware)action : null;
        if (this.ordered) {
            params = new TreeMap(this.getOrderedComparator());
            acceptableParameters = new TreeMap(this.getOrderedComparator());
            params.putAll(parameters);
        } else {
            params = new TreeMap<String, Object>(parameters);
            acceptableParameters = new TreeMap();
        }
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            boolean acceptableName = this.acceptableName(name) && (parameterNameAware == null || parameterNameAware.acceptableParameterName(name));
            if (!acceptableName) continue;
            acceptableParameters.put(name, entry.getValue());
        }
        ValueStack newStack = this.valueStackFactory.createValueStack(stack);
        boolean clearableStack = newStack instanceof ClearableValueStack;
        if (clearableStack) {
            ((ClearableValueStack)((Object)newStack)).clearContextValues();
            Map<String, Object> context = newStack.getContext();
            ReflectionContextState.setCreatingNullObjects(context, true);
            ReflectionContextState.setDenyMethodExecution(context, true);
            ReflectionContextState.setReportingConversionErrors(context, true);
            context.put("com.opensymphony.xwork2.ActionContext.locale", stack.getContext().get("com.opensymphony.xwork2.ActionContext.locale"));
        }
        if (memberAccessStack = newStack instanceof MemberAccessValueStack) {
            MemberAccessValueStack accessValueStack = (MemberAccessValueStack)((Object)newStack);
            accessValueStack.setAcceptProperties(this.acceptParams);
            accessValueStack.setExcludeProperties(this.excludeParams);
        }
        for (Map.Entry entry : acceptableParameters.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                newStack.setParameter(name, value);
            }
            catch (RuntimeException e) {
                if (!devMode) continue;
                String developerNotification = LocalizedTextUtil.findText(ParametersInterceptor.class, "devmode.notification", ActionContext.getContext().getLocale(), "Developer Notification:\n{0}", new Object[]{"Unexpected Exception caught setting '" + name + "' on '" + action.getClass() + ": " + e.getMessage()});
                LOG.error(developerNotification, new String[0]);
                if (!(action instanceof ValidationAware)) continue;
                ((ValidationAware)action).addActionMessage(developerNotification);
            }
        }
        if (clearableStack && stack.getContext() != null && newStack.getContext() != null) {
            stack.getContext().put("com.opensymphony.xwork2.ActionContext.conversionErrors", newStack.getContext().get("com.opensymphony.xwork2.ActionContext.conversionErrors"));
        }
        this.addParametersToContext(ActionContext.getContext(), acceptableParameters);
    }

    protected Comparator<String> getOrderedComparator() {
        return rbCollator;
    }

    private String getParameterLogMap(Map<String, Object> parameters) {
        if (parameters == null) {
            return "NONE";
        }
        StringBuilder logEntry = new StringBuilder();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            logEntry.append(String.valueOf(entry.getKey()));
            logEntry.append(" => ");
            if (entry.getValue() instanceof Object[]) {
                Object[] valueArray = (Object[])entry.getValue();
                logEntry.append("[ ");
                if (valueArray.length > 0) {
                    for (int indexA = 0; indexA < valueArray.length - 1; ++indexA) {
                        Object valueAtIndex = valueArray[indexA];
                        logEntry.append(String.valueOf(valueAtIndex));
                        logEntry.append(", ");
                    }
                    logEntry.append(String.valueOf(valueArray[valueArray.length - 1]));
                }
                logEntry.append(" ] ");
                continue;
            }
            logEntry.append(String.valueOf(entry.getValue()));
        }
        return logEntry.toString();
    }

    protected boolean acceptableName(String name) {
        return this.isAccepted(name) && !this.isExcluded(name);
    }

    protected boolean isAccepted(String paramName) {
        if (!this.acceptParams.isEmpty()) {
            for (Pattern pattern : this.acceptParams) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
        return this.acceptedPattern.matcher(paramName).matches();
    }

    protected boolean isExcluded(String paramName) {
        if (!this.excludeParams.isEmpty()) {
            for (Pattern pattern : this.excludeParams) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    protected Set getExcludeParamsSet() {
        return this.excludeParams;
    }

    public void setExcludeParams(String commaDelim) {
        Collection<String> excludePatterns = ArrayUtils.asCollection(commaDelim);
        if (excludePatterns != null) {
            this.excludeParams = new HashSet<Pattern>();
            for (String pattern : excludePatterns) {
                this.excludeParams.add(Pattern.compile(pattern));
            }
        }
    }
}

