/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class RepopulateConversionErrorFieldValidatorSupport
extends FieldValidatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RepopulateConversionErrorFieldValidatorSupport.class);
    private String repopulateFieldAsString = "false";
    private boolean repopulateFieldAsBoolean = false;

    public String getRepopulateField() {
        return this.repopulateFieldAsString;
    }

    public void setRepopulateField(String repopulateField) {
        this.repopulateFieldAsString = repopulateField == null ? repopulateField : repopulateField.trim();
        this.repopulateFieldAsBoolean = "true".equalsIgnoreCase(this.repopulateFieldAsString);
    }

    public void validate(Object object) throws ValidationException {
        this.doValidate(object);
        if (this.repopulateFieldAsBoolean) {
            this.repopulateField(object);
        }
    }

    public void repopulateField(Object object) throws ValidationException {
        ActionInvocation invocation = ActionContext.getContext().getActionInvocation();
        Map<String, Object> conversionErrors = ActionContext.getContext().getConversionErrors();
        String fieldName = this.getFieldName();
        String fullFieldName = this.getValidatorContext().getFullFieldName(fieldName);
        if (conversionErrors.containsKey(fullFieldName)) {
            Object value = conversionErrors.get(fullFieldName);
            final LinkedHashMap<String, String> fakeParams = new LinkedHashMap<String, String>();
            boolean doExprOverride = false;
            if (value instanceof String[]) {
                String[] tmpValue = (String[])value;
                if (tmpValue.length > 0) {
                    doExprOverride = true;
                    fakeParams.put(fullFieldName, this.escape(tmpValue[0]));
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("value is an empty array of String or with first element in it as null [" + value + "], will not repopulate conversion error ", new String[0]);
                }
            } else if (value instanceof String) {
                String tmpValue = (String)value;
                doExprOverride = true;
                fakeParams.put(fullFieldName, this.escape(tmpValue));
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("conversion error value is not a String or array of String but instead is [" + value + "], will not repopulate conversion error", new String[0]);
            }
            if (doExprOverride) {
                invocation.addPreResultListener(new PreResultListener(){

                    public void beforeResult(ActionInvocation invocation, String resultCode) {
                        ValueStack stack = ActionContext.getContext().getValueStack();
                        stack.setExprOverrides(fakeParams);
                    }
                });
            }
        }
    }

    protected String escape(String value) {
        return "\"" + StringEscapeUtils.escapeJava((String)value) + "\"";
    }

    protected abstract void doValidate(Object var1) throws ValidationException;
}

