/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.logging;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.commons.CommonsLoggerFactory;
import com.opensymphony.xwork2.util.logging.jdk.JdkLoggerFactory;
import com.opensymphony.xwork2.util.logging.slf4j.Slf4jLoggerFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggerFactory {
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static LoggerFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoggerFactory(LoggerFactory factory) {
        lock.writeLock().lock();
        try {
            LoggerFactory.factory = factory;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static Logger getLogger(Class<?> cls) {
        return LoggerFactory.getLoggerFactory().getLoggerImpl(cls);
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLoggerFactory().getLoggerImpl(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LoggerFactory getLoggerFactory() {
        lock.readLock().lock();
        try {
            if (factory != null) {
                LoggerFactory loggerFactory = factory;
                return loggerFactory;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            if (factory == null) {
                try {
                    Class.forName("org.slf4j.LoggerFactory");
                    factory = new Slf4jLoggerFactory();
                }
                catch (ClassNotFoundException ex) {
                    try {
                        Class.forName("org.apache.commons.logging.LogFactory");
                        factory = new CommonsLoggerFactory();
                    }
                    catch (ClassNotFoundException cnfex) {
                        factory = new JdkLoggerFactory();
                    }
                }
            }
            LoggerFactory loggerFactory = factory;
            return loggerFactory;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    protected abstract Logger getLoggerImpl(Class<?> var1);

    protected abstract Logger getLoggerImpl(String var1);
}

