/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRangeValidator<T extends Comparable>
extends FieldValidatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRangeValidator.class);
    private final Class<T> type;
    private T min;
    private T max;

    protected AbstractRangeValidator(Class<T> type) {
        this.type = type;
    }

    @Override
    public void validate(Object object) throws ValidationException {
        T maxComparatorValue;
        Object obj = this.getFieldValue(this.getFieldName(), object);
        Comparable value = (Comparable)obj;
        if (value == null) {
            return;
        }
        T minComparatorValue = this.getMin();
        if (minComparatorValue != null && value.compareTo(minComparatorValue) < 0) {
            this.addFieldError(this.getFieldName(), object);
        }
        if ((maxComparatorValue = this.getMax()) != null && value.compareTo(maxComparatorValue) > 0) {
            this.addFieldError(this.getFieldName(), object);
        }
    }

    public void setMin(T min) {
        this.min = min;
    }

    public T getMin() {
        return this.min;
    }

    public void setMinExpression(String minExpression) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("${minExpression} was defined as [#0]", minExpression);
        }
        this.min = (Comparable)this.parse(minExpression, this.type);
    }

    public void setMax(T max) {
        this.max = max;
    }

    public T getMax() {
        return this.max;
    }

    public void setMaxExpression(String maxExpression) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("${maxExpression} was defined as [#0]", maxExpression);
        }
        this.max = (Comparable)this.parse(maxExpression, this.type);
    }
}

