/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;

public class DoubleRangeFieldValidator
extends FieldValidatorSupport {
    private Double maxInclusive = null;
    private Double minInclusive = null;
    private Double minExclusive = null;
    private Double maxExclusive = null;

    public void validate(Object object) throws ValidationException {
        Double value;
        String fieldName = this.getFieldName();
        try {
            Object obj = this.getFieldValue(fieldName, object);
            if (obj == null) {
                return;
            }
            value = Double.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            return;
        }
        if (this.maxInclusive != null && value.compareTo(this.maxInclusive) > 0 || this.minInclusive != null && value.compareTo(this.minInclusive) < 0 || this.maxExclusive != null && value.compareTo(this.maxExclusive) >= 0 || this.minExclusive != null && value.compareTo(this.minExclusive) <= 0) {
            this.addFieldError(fieldName, object);
        }
    }

    public void setMaxInclusive(Double maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public Double getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMinInclusive(Double minInclusive) {
        this.minInclusive = minInclusive;
    }

    public Double getMinInclusive() {
        return this.minInclusive;
    }

    public Double getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(Double minExclusive) {
        this.minExclusive = minExclusive;
    }

    public Double getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(Double maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public void setMinInclusiveExpression(String minInclusiveExpression) {
        this.minInclusive = (Double)this.parse(minInclusiveExpression, Double.class);
    }

    public void setMaxInclusiveExpression(String maxInclusiveExpression) {
        this.maxInclusive = (Double)this.parse(maxInclusiveExpression, Double.class);
    }

    public void setMinExclusiveExpression(String minExclusiveExpression) {
        this.minExclusive = (Double)this.parse(minExclusiveExpression, Double.class);
    }

    public void setMaxExclusiveExpression(String maxExclusiveExpression) {
        this.maxExclusive = (Double)this.parse(maxExclusiveExpression, Double.class);
    }
}

