/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexFieldValidator
extends FieldValidatorSupport {
    private String regex;
    private boolean caseSensitive = true;
    private boolean trim = true;

    public void validate(Object object) throws ValidationException {
        Matcher matcher;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null || this.regex == null) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String str = ((String)value).trim();
        if (str.length() == 0) {
            return;
        }
        Pattern pattern = this.isCaseSensitive() ? Pattern.compile(this.regex) : Pattern.compile(this.regex, 2);
        String compare = (String)value;
        if (this.trim) {
            compare = compare.trim();
        }
        if (!(matcher = pattern.matcher(compare)).matches()) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setRegexExpression(String regexExpression) {
        this.regex = (String)this.parse(regexExpression, String.class);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setCaseSensitiveExpression(String caseSensitiveExpression) {
        this.caseSensitive = (Boolean)this.parse(caseSensitiveExpression, Boolean.class);
    }

    public boolean isTrimed() {
        return this.trim;
    }

    public void setTrim(Boolean trim) {
        this.trim = trim;
    }

    public void setTrimExpression(String trimExpression) {
        this.trim = (Boolean)this.parse(trimExpression, Boolean.class);
    }
}

