/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;

public class StringLengthFieldValidator
extends FieldValidatorSupport {
    private boolean trim = true;
    private int maxLength = -1;
    private int minLength = -1;

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxLengthExpression(String maxLengthExpression) {
        this.maxLength = (Integer)this.parse(maxLengthExpression, Integer.class);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMinLengthExpression(String minLengthExpression) {
        this.minLength = (Integer)this.parse(minLengthExpression, Integer.class);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public void setTrimExpression(String trimExpression) {
        this.trim = (Boolean)this.parse(trimExpression, Boolean.class);
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void validate(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        String val = (String)this.getFieldValue(fieldName, object);
        if (val == null || val.length() <= 0) {
            return;
        }
        if (this.trim && (val = val.trim()).length() <= 0) {
            return;
        }
        if (this.minLength > -1 && val.length() < this.minLength) {
            this.addFieldError(fieldName, object);
        } else if (this.maxLength > -1 && val.length() > this.maxLength) {
            this.addFieldError(fieldName, object);
        }
    }
}

