/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(URLUtil.class);
    public static final String JBOSS5_VFS = "vfs";
    public static final String JBOSS5_VFSZIP = "vfszip";
    public static final String JBOSS5_VFSMEMORY = "vfsmemory";
    public static final String JBOSS5_VFSFILE = "vfsfile";
    private static final Pattern JAR_PATTERN = Pattern.compile("^(jar:|wsjar:|zip:|vfsfile:|code-source:)?(file:)?(.*?)(\\!/|\\.jar/)(.*)");
    private static final int JAR_FILE_PATH = 3;

    public static URL normalizeToFileProtocol(URL url) {
        String fileName = url.toExternalForm();
        Matcher jarMatcher = JAR_PATTERN.matcher(fileName);
        try {
            if (URLUtil.isJBossUrl(url)) {
                return URLUtil.getJBossPhysicalUrl(url);
            }
            if (jarMatcher.matches()) {
                String path = jarMatcher.group(3);
                return new URL("file", "", path);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            LOG.warn("Error opening JBoss vfs file", e, new String[0]);
            return null;
        }
    }

    public static boolean verifyUrl(String url) {
        if (url == null) {
            return false;
        }
        if (url.startsWith("https://")) {
            url = "http://" + url.substring(8);
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isJarURL(URL fileUrl) {
        Matcher jarMatcher = JAR_PATTERN.matcher(fileUrl.getPath());
        return jarMatcher.matches();
    }

    public static boolean isJBossUrl(URL fileUrl) {
        String protocol = fileUrl.getProtocol();
        return JBOSS5_VFSZIP.equals(protocol) || JBOSS5_VFSMEMORY.equals(protocol) || JBOSS5_VFS.equals(protocol) || "true".equals(System.getProperty("jboss.vfs.forceVfsJar")) && JBOSS5_VFSFILE.equals(protocol);
    }

    public static URL getJBossPhysicalUrl(URL url) throws IOException {
        Object content = url.openConnection().getContent();
        try {
            String s = content.getClass().toString();
            if (s.startsWith("class org.jboss.vfs.VirtualFile")) {
                File physicalFile = URLUtil.readJBossPhysicalFile(content);
                return physicalFile.toURI().toURL();
            }
            if (s.startsWith("class org.jboss.virtual.VirtualFile")) {
                String fileName = url.toExternalForm();
                return new URL("file", null, fileName.substring(fileName.indexOf(":") + 1));
            }
        }
        catch (Exception e) {
            LOG.warn("Error calling getPhysicalFile() on JBoss VirtualFile.", e, new String[0]);
        }
        return url;
    }

    public static List<URL> getAllJBossPhysicalUrls(URL url) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Object content = url.openConnection().getContent();
        try {
            if (content.getClass().toString().startsWith("class org.jboss.vfs.VirtualFile")) {
                File physicalFile = URLUtil.readJBossPhysicalFile(content);
                URLUtil.readFile(urls, physicalFile);
                URLUtil.readFile(urls, physicalFile.getParentFile());
            } else {
                urls.add(url);
            }
        }
        catch (Exception e) {
            LOG.warn("Error calling getPhysicalFile() on JBoss VirtualFile.", e, new String[0]);
        }
        return urls;
    }

    private static File readJBossPhysicalFile(Object content) throws Exception {
        Method method = content.getClass().getDeclaredMethod("getPhysicalFile", new Class[0]);
        return (File)method.invoke(content, new Object[0]);
    }

    private static void readFile(List<URL> urls, File physicalFile) throws MalformedURLException {
        if (physicalFile.isDirectory()) {
            for (File file : physicalFile.listFiles()) {
                if (file.isFile()) {
                    URLUtil.addIfAbsent(urls, file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                URLUtil.readFile(urls, file);
            }
        }
    }

    private static void addIfAbsent(List<URL> urls, URL fileUrl) {
        if (!urls.contains(fileUrl)) {
            urls.add(fileUrl);
        }
    }
}

