/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.fs;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.util.URLUtil;
import com.opensymphony.xwork2.util.fs.FileRevision;
import com.opensymphony.xwork2.util.fs.JBossFileRevision;
import com.opensymphony.xwork2.util.fs.JarEntryRevision;
import com.opensymphony.xwork2.util.fs.Revision;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultFileManager
implements FileManager {
    private static Logger LOG = LoggerFactory.getLogger(DefaultFileManager.class);
    private static Map<String, Revision> files = Collections.synchronizedMap(new HashMap());
    protected boolean reloadingConfigs = true;
    static final String JAR_FILE_NAME_SEPARATOR = "!/";
    static final String JAR_FILE_EXTENSION_END = ".jar/";

    public void setReloadingConfigs(boolean reloadingConfigs) {
        this.reloadingConfigs = reloadingConfigs;
    }

    public boolean isReloadingConfigs() {
        return this.reloadingConfigs;
    }

    public boolean fileNeedsReloading(URL fileUrl) {
        return fileUrl != null && this.fileNeedsReloading(fileUrl.toString());
    }

    public boolean fileNeedsReloading(String fileName) {
        Revision revision = files.get(fileName);
        if (revision == null) {
            return this.reloadingConfigs;
        }
        return revision.needsReloading();
    }

    public InputStream loadFile(URL fileUrl) {
        if (fileUrl == null) {
            return null;
        }
        InputStream is = this.openFile(fileUrl);
        this.monitorFile(fileUrl);
        return is;
    }

    private InputStream openFile(URL fileUrl) {
        try {
            InputStream is = fileUrl.openStream();
            if (is == null) {
                throw new IllegalArgumentException("No file '" + fileUrl + "' found as a resource");
            }
            return is;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("No file '" + fileUrl + "' found as a resource");
        }
    }

    public void monitorFile(URL fileUrl) {
        if (this.isReloadingConfigs()) {
            Revision revision;
            String fileName = fileUrl.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating revision for URL: " + fileName, new String[0]);
            }
            if ((revision = URLUtil.isJBossUrl(fileUrl) ? JBossFileRevision.build(fileUrl) : (URLUtil.isJarURL(fileUrl) ? JarEntryRevision.build(fileUrl) : FileRevision.build(fileUrl))) == null) {
                files.put(fileName, Revision.build(fileUrl));
            } else {
                files.put(fileName, revision);
            }
        }
    }
}

