/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.fs;

import com.opensymphony.xwork2.util.URLUtil;
import com.opensymphony.xwork2.util.fs.FileRevision;
import com.opensymphony.xwork2.util.fs.Revision;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

class JBossFileRevision
extends FileRevision {
    public JBossFileRevision(File file, long lastUpdated) {
        super(file, lastUpdated);
    }

    public static Revision build(URL fileUrl) {
        File file;
        URL url = URLUtil.normalizeToFileProtocol(fileUrl);
        try {
            if (url == null) {
                return null;
            }
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(url.getPath());
        }
        if (file.exists() && file.canRead()) {
            long lastModified = file.lastModified();
            return new FileRevision(file, lastModified);
        }
        return null;
    }
}

