/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.fs;

import com.opensymphony.xwork2.util.URLUtil;
import com.opensymphony.xwork2.util.fs.Revision;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;

class JarEntryRevision
extends Revision {
    private static Logger LOG = LoggerFactory.getLogger(JarEntryRevision.class);
    private String jarFileName;
    private String fileNameInJar;
    private long lastModified;

    public JarEntryRevision(String jarFileName, String fileNameInJar, long lastModified) {
        if (jarFileName == null || fileNameInJar == null) {
            throw new IllegalArgumentException("JarFileName and FileNameInJar cannot be null");
        }
        this.jarFileName = jarFileName;
        this.fileNameInJar = fileNameInJar;
        this.lastModified = lastModified;
    }

    public boolean needsReloading() {
        ZipEntry entry;
        try {
            JarFile jarFile = new JarFile(this.jarFileName);
            entry = jarFile.getEntry(this.fileNameInJar);
        }
        catch (IOException e) {
            entry = null;
        }
        return entry != null && this.lastModified < entry.getTime();
    }

    public static Revision build(URL fileUrl) {
        String jarFileName = "";
        try {
            String fileName = fileUrl.toString();
            int separatorIndex = fileName.indexOf("!/");
            if (separatorIndex == -1) {
                separatorIndex = fileName.lastIndexOf(".jar/");
            }
            if (separatorIndex == -1) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Could not find end of jar file!", new String[0]);
                }
                return null;
            }
            jarFileName = fileName.substring(0, separatorIndex);
            int index = separatorIndex + "!/".length();
            String fileNameInJar = fileName.substring(index).replaceAll("%20", " ");
            URL url = URLUtil.normalizeToFileProtocol(fileUrl);
            if (url != null) {
                JarFile jarFile = new JarFile(FileUtils.toFile((URL)url));
                ZipEntry entry = jarFile.getEntry(fileNameInJar);
                return new JarEntryRevision(jarFileName.toString(), fileNameInJar, entry.getTime());
            }
            return null;
        }
        catch (Throwable e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Could not create JarEntryRevision for [" + jarFileName + "]!", e, new String[0]);
            }
            return null;
        }
    }
}

