/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dojo.components;

import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="head", tldBodyContent="empty", tldTagClass="org.apache.struts2.dojo.views.jsp.ui.HeadTag", description="Render a chunk of HEAD for your HTML file")
@StrutsTagSkipInheritance
public class Head
extends org.apache.struts2.components.Head {
    public static final String TEMPLATE = "head";
    public static final String PARSE_CONTENT = "struts.dojo.head.parseContent";
    private String debug;
    private String compressed;
    private String baseRelativePath;
    private String extraLocales;
    private String locale;
    private String cache;
    private String parseContent;

    public Head(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public void evaluateParams() {
        super.evaluateParams();
        if (this.debug != null) {
            this.addParameter("debug", this.findValue(this.debug, Boolean.class));
        }
        if (this.compressed != null) {
            this.addParameter("compressed", this.findValue(this.compressed, Boolean.class));
        }
        if (this.baseRelativePath != null) {
            this.addParameter("baseRelativePath", this.findString(this.baseRelativePath));
        }
        if (this.extraLocales != null) {
            String locales = this.findString(this.extraLocales);
            this.addParameter("extraLocales", locales.split(","));
        }
        if (this.locale != null) {
            this.addParameter("locale", this.findString(this.locale));
        }
        if (this.cache != null) {
            this.addParameter("cache", this.findValue(this.cache, Boolean.class));
        }
        if (this.parseContent != null) {
            Boolean shouldParseContent = (Boolean)this.findValue(this.parseContent, Boolean.class);
            this.addParameter("parseContent", shouldParseContent);
            this.stack.getContext().put(PARSE_CONTENT, shouldParseContent);
        } else {
            this.addParameter("parseContent", false);
            this.stack.getContext().put(PARSE_CONTENT, false);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "ajax";
    }

    public boolean isDebug() {
        return this.debug != null && Boolean.parseBoolean(this.debug);
    }

    @StrutsTagAttribute(description="Enable Dojo debug messages", defaultValue="false", type="Boolean")
    public void setDebug(String debug) {
        this.debug = debug;
    }

    @StrutsTagAttribute(description="Use compressed version of dojo.js", defaultValue="true", type="Boolean")
    public void setCompressed(String compressed) {
        this.compressed = compressed;
    }

    @StrutsTagAttribute(description="Context relative path of Dojo distribution folder", defaultValue="/struts/dojo")
    public void setBaseRelativePath(String baseRelativePath) {
        this.baseRelativePath = baseRelativePath;
    }

    @StrutsTagAttribute(description="Comma separated list of locale names to be loaded by Dojo, locale names must be specified as in RFC3066")
    public void setExtraLocales(String extraLocales) {
        this.extraLocales = extraLocales;
    }

    @StrutsTagAttribute(description="Default locale to be used by Dojo, locale name must be specified as in RFC3066")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @StrutsTagAttribute(description="Use Struts Dojo profile, which contains all Struts widgets in one file, making it possible to be chached by the browser", defaultValue="true", type="Boolean")
    public void setCache(String cache) {
        this.cache = cache;
    }

    @StrutsTagAttribute(description="Parse the whole document for widgets", defaultValue="false", type="Boolean")
    public void setParseContent(String parseContent) {
        this.parseContent = parseContent;
    }
}

