/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.response;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.submarine.server.api.experiment.ExperimentId;
import org.apache.submarine.server.gson.ExperimentIdDeserializer;
import org.apache.submarine.server.gson.ExperimentIdSerializer;
import org.apache.submarine.server.response.DictAnnotation;
import org.apache.submarine.server.response.JsonExclusionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResponse<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonResponse.class);
    private final Response.Status status;
    private final int code;
    private final Boolean success;
    private final String message;
    private final T result;
    private final transient ArrayList<NewCookie> cookies;
    private final transient boolean pretty = false;
    private final Map<String, Object> attributes;
    private static Gson safeGson = null;
    private static final String CGLIB_PROPERTY_PREFIX = "\\$cglib_prop_";

    private JsonResponse(Builder<T> builder) {
        this.code = ((Builder)builder).code;
        this.success = ((Builder)builder).success;
        this.message = ((Builder)builder).message;
        this.attributes = ((Builder)builder).attributes;
        this.result = ((Builder)builder).result;
        this.cookies = ((Builder)builder).cookies;
        this.status = ((Builder)builder).status != null ? ((Builder)builder).status : Response.Status.fromStatusCode((int)this.code);
    }

    public T getResult() {
        return this.result;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    @VisibleForTesting
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        if (safeGson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new JsonExclusionStrategy()});
            Gson gson = gsonBuilder.setDateFormat("yyyy-MM-dd HH:mm:ss").create();
            TypeAdapter dateTypeAdapter = gson.getAdapter(Date.class);
            TypeAdapter safeDateTypeAdapter = dateTypeAdapter.nullSafe();
            safeGson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)safeDateTypeAdapter).registerTypeAdapter(ExperimentId.class, (Object)new ExperimentIdSerializer()).registerTypeAdapter(ExperimentId.class, (Object)new ExperimentIdDeserializer()).serializeNulls().create();
        }
        boolean haveDictAnnotation = false;
        try {
            if (null != this.getResult()) {
                haveDictAnnotation = DictAnnotation.parseDictAnnotation(this.getResult());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        String json = safeGson.toJson((Object)this);
        if (haveDictAnnotation) {
            json = json.replaceAll(CGLIB_PROPERTY_PREFIX, "");
        }
        return json;
    }

    private synchronized Response build() {
        Response.ResponseBuilder r = Response.status((Response.Status)this.status).entity((Object)this.toString());
        if (this.cookies != null) {
            for (NewCookie nc : this.cookies) {
                r.cookie(new NewCookie[]{nc});
            }
        }
        return r.build();
    }

    public static class ListResult<T> {
        private List<T> records;
        private long total;

        public ListResult(List<T> records, long total) {
            this.records = records;
            this.total = total;
        }

        public List<T> getRecords() {
            return this.records;
        }

        public void setRecords(List<T> records) {
            this.records = records;
        }

        public long getTotal() {
            return this.total;
        }

        public void setTotal(long total) {
            this.total = total;
        }
    }

    public static class Builder<T> {
        private Response.Status status;
        private int code;
        private Boolean success;
        private String message;
        private T result;
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private transient ArrayList<NewCookie> cookies;
        private transient boolean pretty = false;

        public Builder(Response.Status status) {
            this.status = status;
            this.code = status.getStatusCode();
        }

        public Builder(int code) {
            this.code = code;
        }

        public Builder<T> attribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder<T> success(Boolean success) {
            this.success = success;
            return this;
        }

        public Builder<T> message(String message) {
            this.message = message;
            return this;
        }

        public Builder<T> result(T result) {
            this.result = result;
            return this;
        }

        public Builder<T> code(int code) {
            this.code = code;
            return this;
        }

        public Builder<T> cookies(ArrayList<NewCookie> newCookies) {
            if (this.cookies == null) {
                this.cookies = new ArrayList();
            }
            this.cookies.addAll(newCookies);
            return this;
        }

        public Response build() {
            JsonResponse jsonResponse = new JsonResponse(this);
            return jsonResponse.build();
        }
    }
}

