/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GitUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clone(String remotePath, String localPath, String token, String branch) {
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider("PRIVATE-TOKEN", token);
        try (Git git = null;){
            git = ((CloneCommand)Git.cloneRepository().setURI(remotePath).setBranch(branch).setDirectory(new File(localPath)).setCredentialsProvider((CredentialsProvider)credentialsProvider)).call();
        }
        LOG.info("git.tag(): {}", (Object)git.tag());
    }

    public DirCache add(String localPath, String fileName) {
        File myfile = new File(localPath + fileName);
        if (!myfile.exists()) {
            myfile.getParentFile().mkdirs();
            try {
                myfile.createNewFile();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        DirCache dirCache = null;
        try (Git git = Git.open((File)new File(localPath));){
            dirCache = git.add().addFilepattern(fileName.substring(1)).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return dirCache;
    }

    public DirCache rm(String localPath, String fileName) {
        DirCache dirCache = null;
        try (Git git = Git.open((File)new File(localPath));){
            dirCache = git.rm().addFilepattern(fileName.substring(1)).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return dirCache;
    }

    public void reset(String localPath, String fileName) {
        try (Git git = Git.open((File)new File(localPath));){
            git.reset().addPath(fileName.substring(1)).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public PullResult pull(String localPath, String token, String branch) {
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider("PRIVATE-TOKEN", token);
        PullResult pullResult = null;
        try (Git git = Git.open((File)new File(localPath));){
            pullResult = ((PullCommand)git.pull().setRemoteBranchName(branch).setCredentialsProvider((CredentialsProvider)credentialsProvider)).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return pullResult;
    }

    public RevCommit commit(String localPath, String message) {
        RevCommit revCommit = null;
        try (Git git = Git.open((File)new File(localPath));){
            revCommit = git.commit().setMessage(message).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return revCommit;
    }

    public Iterable<PushResult> push(String localPath, String token, String remote) {
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider("PRIVATE-TOKEN", token);
        Iterable iterable = null;
        try (Git git = Git.open((File)new File(localPath));){
            iterable = ((PushCommand)git.push().setRemote(remote).setCredentialsProvider((CredentialsProvider)credentialsProvider)).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return iterable;
    }

    public Ref branchCreate(String localPath, String branchName) {
        Ref result = null;
        try (Git git = Git.open((File)new File(localPath));){
            ListBranchCommand listBranchCommand = git.branchList();
            List list = listBranchCommand.call();
            boolean existsBranch = false;
            for (Ref ref : list) {
                if (!ref.getName().endsWith(branchName)) continue;
                existsBranch = true;
                break;
            }
            if (!existsBranch) {
                result = git.branchCreate().setName(branchName).call();
            } else {
                LOG.warn("{} already exists.", (Object)branchName);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<String> branchDelete(String localPath, String branchName) {
        List list = null;
        try (Git git = Git.open((File)new File(localPath));){
            list = git.branchDelete().setForce(true).setBranchNames(new String[]{branchName}).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public Ref checkout(String localPath, String branchName) {
        Ref result = null;
        try (Git git = Git.open((File)new File(localPath));){
            result = git.checkout().setName(branchName).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void rebase(String localPath, String branchName, String upstreamName) {
        try (Git git = Git.open((File)new File(localPath));){
            git.rebase().setUpstream(branchName).setUpstreamName(upstreamName).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void remoteAdd(String localPath, String uri, String remoteName) {
        try (Git git = Git.open((File)new File(localPath));){
            URIish urIish = new URIish(uri);
            git.remoteAdd().setName(remoteName).setUri(urIish).call();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (GitAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

