/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.workbench.database.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.Project;
import org.apache.submarine.server.workbench.database.entity.ProjectFiles;
import org.apache.submarine.server.workbench.database.mappers.ProjectFilesMapper;
import org.apache.submarine.server.workbench.database.mappers.ProjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectService {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectService.class);

    public List<Project> queryPageList(String userName, String column, String order, int pageNo, int pageSize) throws Exception {
        LOG.info("queryPageList owner:{}, column:{}, order:{}, pageNo:{}, pageSize:{}", new Object[]{userName, column, order, pageNo, pageSize});
        List<Project> list = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ProjectMapper projectMapper = (ProjectMapper)sqlSession.getMapper(ProjectMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("userName", userName);
            where.put("column", column);
            where.put("order", order);
            list = projectMapper.selectAll(where, new RowBounds(pageNo, pageSize));
            ProjectFilesMapper projectFilesMapper = (ProjectFilesMapper)sqlSession.getMapper(ProjectFilesMapper.class);
            for (Project project : list) {
                HashMap<String, Object> whereMember = new HashMap<String, Object>();
                whereMember.put("projectId", project.getId());
                List<ProjectFiles> projectFilesList = projectFilesMapper.selectAll(whereMember);
                for (ProjectFiles projectFiles : projectFilesList) {
                    project.addProjectFilesList(projectFiles);
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return list;
    }

    public boolean add(Project project) throws Exception {
        LOG.info("add({})", (Object)project.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ProjectMapper projectMapper = (ProjectMapper)sqlSession.getMapper(ProjectMapper.class);
            projectMapper.insert(project);
            ProjectFilesMapper projectFilesMapper = (ProjectFilesMapper)sqlSession.getMapper(ProjectFilesMapper.class);
            List<ProjectFiles> list = project.getProjectFilesList();
            for (ProjectFiles projectFiles : list) {
                projectFiles.setProjectId(project.getId());
                projectFilesMapper.insert(projectFiles);
            }
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean updateByPrimaryKeySelective(Project project) throws Exception {
        LOG.info("updateByPrimaryKeySelective({})", (Object)project.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ProjectMapper projectMapper = (ProjectMapper)sqlSession.getMapper(ProjectMapper.class);
            projectMapper.updateByPrimaryKeySelective(project);
            ProjectFilesMapper projectFilesMapper = (ProjectFilesMapper)sqlSession.getMapper(ProjectFilesMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("projectId", project.getId());
            List<ProjectFiles> oldProjectFiles = projectFilesMapper.selectAll(where);
            ArrayList<String> oldProjectFilesId = new ArrayList<String>();
            for (ProjectFiles oldProjectFile : oldProjectFiles) {
                oldProjectFilesId.add(oldProjectFile.getId());
            }
            List<ProjectFiles> currProjectFiles = project.getProjectFilesList();
            ArrayList<String> currProjectFilesId = new ArrayList<String>();
            for (ProjectFiles currProjectFile : currProjectFiles) {
                currProjectFilesId.add(currProjectFile.getId());
            }
            for (ProjectFiles old : oldProjectFiles) {
                if (!currProjectFilesId.contains(old.getId())) {
                    projectFilesMapper.deleteByPrimaryKey(old.getId());
                    continue;
                }
                for (ProjectFiles currProjectFile : currProjectFiles) {
                    if (currProjectFile.getId() == null || !currProjectFile.getId().equals(old.getId())) continue;
                    projectFilesMapper.updateByPrimaryKeySelective(currProjectFile);
                }
            }
            for (ProjectFiles curr : currProjectFiles) {
                if (curr.getId() != null) continue;
                curr.setProjectId(project.getId());
                projectFilesMapper.insert(curr);
            }
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean delete(String id) throws Exception {
        LOG.info("delete({})", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            ProjectMapper projectMapper = (ProjectMapper)sqlSession.getMapper(ProjectMapper.class);
            projectMapper.deleteByPrimaryKey(id);
            ProjectFilesMapper projectFilesMapper = (ProjectFilesMapper)sqlSession.getMapper(ProjectFilesMapper.class);
            ProjectFiles projectFiles = new ProjectFiles();
            projectFiles.setProjectId(id);
            projectFilesMapper.deleteSelective(projectFiles);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }
}

