/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.service;

import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.workbench.database.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.TeamMember;
import org.apache.submarine.server.workbench.database.mappers.TeamMemberMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamMemberService {
    private static final Logger LOG = LoggerFactory.getLogger(TeamMemberService.class);

    public List<TeamMember> queryList(String teamId) throws Exception {
        LOG.info("queryList teamId:{}", (Object)teamId);
        List<TeamMember> list = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            TeamMemberMapper teamMemberMapper = (TeamMemberMapper)sqlSession.getMapper(TeamMemberMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("teamId", teamId);
            list = teamMemberMapper.selectAll(where);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return list;
    }

    public boolean insertSelective(TeamMember teamMember) throws Exception {
        LOG.info("insertSelective({})", (Object)teamMember.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            TeamMemberMapper teamMemberMapper = (TeamMemberMapper)sqlSession.getMapper(TeamMemberMapper.class);
            teamMemberMapper.insertSelective(teamMember);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public void deleteByPrimaryKey(String id) throws Exception {
        LOG.info("deleteByPrimaryKey({})", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            TeamMemberMapper teamMemberMapper = (TeamMemberMapper)sqlSession.getMapper(TeamMemberMapper.class);
            teamMemberMapper.deleteByPrimaryKey(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }
}

