/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.database.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.workbench.database.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.Team;
import org.apache.submarine.server.workbench.database.entity.TeamMember;
import org.apache.submarine.server.workbench.database.mappers.TeamMapper;
import org.apache.submarine.server.workbench.database.mappers.TeamMemberMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamService {
    private static final Logger LOG = LoggerFactory.getLogger(TeamService.class);

    public List<Team> queryPageList(String owner, String column, String order, int pageNo, int pageSize) throws Exception {
        LOG.info("queryPageList owner:{}, column:{}, order:{}, pageNo:{}, pageSize:{}", new Object[]{owner, column, order, pageNo, pageSize});
        List<Team> list = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            TeamMapper teamMapper = (TeamMapper)sqlSession.getMapper(TeamMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("owner", owner);
            where.put("column", column);
            where.put("order", order);
            list = teamMapper.selectAll(where, new RowBounds(pageNo, pageSize));
            TeamMemberMapper teamMemberMapper = (TeamMemberMapper)sqlSession.getMapper(TeamMemberMapper.class);
            for (Team team : list) {
                HashMap<String, Object> whereMember = new HashMap<String, Object>();
                whereMember.put("teamId", team.getId());
                List<TeamMember> teamMembers = teamMemberMapper.selectAll(whereMember);
                for (TeamMember teamMember : teamMembers) {
                    team.addCollaborator(teamMember);
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return list;
    }

    public boolean add(Team team) throws Exception {
        LOG.info("add({})", (Object)team.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            TeamMapper teamMapper = (TeamMapper)sqlSession.getMapper(TeamMapper.class);
            teamMapper.insert(team);
            TeamMemberMapper teamMemberMapper = (TeamMemberMapper)sqlSession.getMapper(TeamMemberMapper.class);
            List<TeamMember> list = team.getCollaborators();
            for (TeamMember teamMember : list) {
                teamMember.setTeamId(team.getId());
                teamMemberMapper.insert(teamMember);
            }
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean updateByPrimaryKeySelective(Team team) throws Exception {
        LOG.info("updateByPrimaryKeySelective({})", (Object)team.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            TeamMapper teamMapper = (TeamMapper)sqlSession.getMapper(TeamMapper.class);
            teamMapper.updateByPrimaryKeySelective(team);
            TeamMemberMapper teamMemberMapper = (TeamMemberMapper)sqlSession.getMapper(TeamMemberMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("teamId", team.getId());
            List<TeamMember> oldTeamMembers = teamMemberMapper.selectAll(where);
            ArrayList<String> oldMembers = new ArrayList<String>();
            for (TeamMember oldTeamMember : oldTeamMembers) {
                oldMembers.add(oldTeamMember.getMember());
            }
            List<TeamMember> newTeamMembers = team.getCollaborators();
            ArrayList<String> newMembers = new ArrayList<String>();
            for (TeamMember newTeamMember : newTeamMembers) {
                newMembers.add(newTeamMember.getMember());
            }
            for (TeamMember oldTeamMember : oldTeamMembers) {
                if (newMembers.contains(oldTeamMember.getMember())) continue;
                teamMemberMapper.deleteByPrimaryKey(oldTeamMember.getId());
            }
            for (TeamMember newTeamMember : newTeamMembers) {
                if (oldMembers.contains(newTeamMember.getMember())) continue;
                newTeamMember.setTeamId(team.getId());
                newTeamMember.setTeamName(team.getTeamName());
                teamMemberMapper.insert(newTeamMember);
            }
            TeamMember teamMember = new TeamMember();
            teamMember.setTeamName(team.getTeamName());
            teamMember.setTeamId(team.getId());
            teamMemberMapper.updateSelective(teamMember);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public boolean delete(String id) throws Exception {
        LOG.info("delete({})", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            TeamMapper teamMapper = (TeamMapper)sqlSession.getMapper(TeamMapper.class);
            teamMapper.deleteByPrimaryKey(id);
            TeamMemberMapper teamMemberMapper = (TeamMemberMapper)sqlSession.getMapper(TeamMemberMapper.class);
            TeamMember teamMember = new TeamMember();
            teamMember.setTeamId(id);
            teamMemberMapper.deleteSelective(teamMember);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }
}

