/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.entity;

import java.util.List;
import org.apache.submarine.server.workbench.entity.Action;

public class Permission {
    private final String roleId;
    private final String permissionId;
    private final String permissionName;
    private final String dataAccess;
    private final List<Action> actionList;
    private final List<Action> actions;
    private final List<Action> actionEntitySet;

    private Permission(Builder builder) {
        this.roleId = builder.roleId;
        this.permissionId = builder.permissionId;
        this.permissionName = builder.permissionName;
        this.dataAccess = builder.dataAccess;
        this.actionList = builder.actionList;
        this.actions = builder.actions;
        this.actionEntitySet = builder.actionEntitySet;
    }

    public String toString() {
        return "User{roleId='" + this.roleId + '\'' + ", permissionId='" + this.permissionId + '\'' + ", permissionName=" + this.permissionName + ", dataAccess='" + this.dataAccess + '\'' + ", actionList=" + this.actionList.toString() + ", actions='" + this.actions.toString() + '\'' + ", actionEntitySet='" + this.actionEntitySet.toString() + '\'' + '}';
    }

    public static class Builder {
        private final String roleId;
        private final String permissionId;
        private final String permissionName;
        private String dataAccess;
        private List<Action> actionList;
        private List<Action> actions;
        private List<Action> actionEntitySet;

        public Builder(String roleId, String permissionId, String permissionName) {
            this.roleId = roleId;
            this.permissionId = permissionId;
            this.permissionName = permissionName;
        }

        public Builder dataAccess(String dataAccess) {
            this.dataAccess = dataAccess;
            return this;
        }

        public Builder actionList(List<Action> actionList) {
            this.actionList = actionList;
            return this;
        }

        public Builder actions(List<Action> actions) {
            this.actions = actions;
            return this;
        }

        public Builder actionEntitySet(List<Action> actionEntitySet) {
            this.actionEntitySet = actionEntitySet;
            return this;
        }

        public Permission build() {
            return new Permission(this);
        }
    }
}

