/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.rest;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.response.JsonResponse;
import org.apache.submarine.server.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.workbench.database.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.SysDept;
import org.apache.submarine.server.workbench.database.entity.SysDeptSelect;
import org.apache.submarine.server.workbench.database.entity.SysDeptTree;
import org.apache.submarine.server.workbench.database.mappers.SysDeptMapper;
import org.apache.submarine.server.workbench.database.utils.DepartmentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sys/dept")
@Produces(value={"application/json"})
@Singleton
public class SysDeptRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(SysDeptRestApi.class);
    public static final String SHOW_ALERT = "showAlert";

    @Inject
    public SysDeptRestApi() {
    }

    @GET
    @Path(value="/tree")
    @SubmarineApi
    public Response tree(@QueryParam(value="deptCode") String likeDeptCode, @QueryParam(value="deptName") String likeDeptName) {
        LOG.info("SysDeptRestApi.tree()");
        List<SysDept> sysDeptList = null;
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDeptMapper sysDeptMapper = (SysDeptMapper)sqlSession.getMapper(SysDeptMapper.class);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("deptCode", likeDeptCode);
            where.put("deptName", likeDeptName);
            sysDeptList = sysDeptMapper.selectAll(where);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        ArrayList<SysDeptSelect> sysDeptSelects = new ArrayList<SysDeptSelect>();
        List<SysDeptTree> sysDeptTreeList = DepartmentUtil.wrapDeptListToTree(sysDeptList, sysDeptSelects);
        PageInfo page = new PageInfo(sysDeptList);
        long sizeDeptTreeList = DepartmentUtil.getDeptTreeSize(sysDeptTreeList);
        if ((long)sysDeptList.size() != sizeDeptTreeList) {
            JsonResponse.ListResult<SysDept> listResult = new JsonResponse.ListResult<SysDept>(sysDeptList, page.getTotal());
            JsonResponse.Builder<JsonResponse.ListResult<SysDept>> builder = new JsonResponse.Builder(Response.Status.OK).success(true).result(listResult);
            if (StringUtils.isEmpty((String)likeDeptCode) && StringUtils.isEmpty((String)likeDeptName)) {
                builder.attribute(SHOW_ALERT, Boolean.TRUE);
                LOG.warn("The department's level is set incorrectly. Now show all department in a list.");
            }
            return builder.build();
        }
        JsonResponse.ListResult<SysDeptTree> listResult = new JsonResponse.ListResult<SysDeptTree>(sysDeptTreeList, page.getTotal());
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(listResult).build();
    }

    @GET
    @Path(value="/queryIdTree")
    @SubmarineApi
    public Response queryIdTree(@QueryParam(value="disableDeptCode") String disableDeptCode) {
        LOG.info("queryIdTree({})", (Object)disableDeptCode);
        ArrayList<SysDeptSelect> sysDeptSelects = new ArrayList<SysDeptSelect>();
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDeptMapper sysDeptMapper = (SysDeptMapper)sqlSession.getMapper(SysDeptMapper.class);
            List<SysDept> sysDeptList = sysDeptMapper.selectAll(new HashMap<String, Object>());
            DepartmentUtil.wrapDeptListToTree(sysDeptList, sysDeptSelects);
            if (!StringUtils.isEmpty((String)disableDeptCode)) {
                DepartmentUtil.disableTagetDeptCode(sysDeptSelects, disableDeptCode);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(sysDeptSelects).build();
    }

    @POST
    @Path(value="/add")
    @SubmarineApi
    public Response add(SysDept sysDept) {
        LOG.info("add({})", (Object)sysDept.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDeptMapper sysDeptMapper = (SysDeptMapper)sqlSession.getMapper(SysDeptMapper.class);
            sysDeptMapper.add(sysDept);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).success(false).message("Save department failed!").build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).message("Save department successfully!").result(sysDept).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Path(value="/edit")
    @SubmarineApi
    public Response edit(SysDept sysDept) {
        LOG.info("edit({})", (Object)sysDept.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDeptMapper sysDeptMapper = (SysDeptMapper)sqlSession.getMapper(SysDeptMapper.class);
            SysDept dept = sysDeptMapper.getById(sysDept.getId());
            if (dept == null) {
                Response response = new JsonResponse.Builder(Response.Status.OK).message("Can not found department:" + sysDept.getId()).success(false).build();
                return response;
            }
            sysDeptMapper.updateBy(sysDept);
            sqlSession.commit();
            return new JsonResponse.Builder(Response.Status.OK).success(true).message("Update department successfully!").build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Update department failed!").success(false).build();
        }
    }

    @PUT
    @Path(value="/resetParentDept")
    @SubmarineApi
    public Response resetParentDept() {
        LOG.info("resetParentDept()");
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDeptMapper sysDeptMapper = (SysDeptMapper)sqlSession.getMapper(SysDeptMapper.class);
            sysDeptMapper.resetDeptLevel();
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Reset department level failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).success(true).message("Reset department level successfully!").build();
    }

    @DELETE
    @Path(value="/delete")
    @SubmarineApi
    public Response delete(@QueryParam(value="id") String id, @QueryParam(value="deleted") int deleted) {
        LOG.info("delete({}, {})", (Object)id, (Object)deleted);
        String msgOperation = "Delete";
        if (deleted == 0) {
            msgOperation = "Restore";
        }
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDeptMapper sysDeptMapper = (SysDeptMapper)sqlSession.getMapper(SysDeptMapper.class);
            SysDept dept = new SysDept();
            dept.setId(id);
            dept.setDeleted(deleted);
            sysDeptMapper.updateBy(dept);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message(msgOperation + " department failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message(msgOperation + " department successfully!").success(true).build();
    }

    @DELETE
    @Path(value="/deleteBatch")
    @SubmarineApi
    public Response deleteBatch(@QueryParam(value="ids") String ids) {
        LOG.info("deleteBatch({})", (Object)ids.toString());
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDeptMapper sysDeptMapper = (SysDeptMapper)sqlSession.getMapper(SysDeptMapper.class);
            sysDeptMapper.deleteBatch(Arrays.asList(ids.split(",")));
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Batch delete department failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Batch delete department successfully!").success(true).build();
    }

    @DELETE
    @Path(value="/remove")
    @SubmarineApi
    public Response remove(String id) {
        LOG.info("remove({})", (Object)id);
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDeptMapper sysDeptMapper = (SysDeptMapper)sqlSession.getMapper(SysDeptMapper.class);
            sysDeptMapper.deleteById(id);
            sqlSession.commit();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Delete department failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Delete department successfully!").success(true).build();
    }
}

