/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.workbench.rest;

import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.submarine.server.response.JsonResponse;
import org.apache.submarine.server.workbench.annotation.SubmarineApi;
import org.apache.submarine.server.workbench.database.MyBatisUtil;
import org.apache.submarine.server.workbench.database.entity.SysDict;
import org.apache.submarine.server.workbench.database.mappers.SysDictMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sys/dict")
@Produces(value={"application/json"})
@Singleton
public class SysDictRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(SysDictRestApi.class);
    private static final Gson gson = new Gson();

    @Inject
    public SysDictRestApi() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/list")
    @SubmarineApi
    public Response list(@QueryParam(value="dictCode") String dictCode, @QueryParam(value="dictName") String dictName, @QueryParam(value="column") String column, @QueryParam(value="field") String field, @QueryParam(value="order") String order, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize) {
        LOG.info("queryDictList column:{}, field:{}, order:{}, pageNo:{}, pageSize:{}", new Object[]{column, field, order, pageNo, pageSize});
        List<SysDict> list = null;
        SqlSession sqlSession = MyBatisUtil.getSqlSession();
        SysDictMapper sysDictMapper = (SysDictMapper)sqlSession.getMapper(SysDictMapper.class);
        try {
            HashMap<String, String> where = new HashMap<String, String>();
            where.put("dictCode", dictCode);
            where.put("dictName", dictName);
            list = sysDictMapper.selectAll(where, new RowBounds(pageNo, pageSize));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            Response response = new JsonResponse.Builder(Response.Status.OK).success(false).build();
            return response;
        }
        finally {
            sqlSession.close();
        }
        PageInfo page = new PageInfo(list);
        JsonResponse.ListResult<SysDict> listResult = new JsonResponse.ListResult<SysDict>(list, page.getTotal());
        return new JsonResponse.Builder(Response.Status.OK).success(true).result(listResult).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/add")
    @SubmarineApi
    public Response add(SysDict sysDict) {
        LOG.info("add Dict:{}", (Object)sysDict.toString());
        try {
            SqlSession sqlSession = MyBatisUtil.getSqlSession();
            SysDictMapper sysDictMapper = (SysDictMapper)sqlSession.getMapper(SysDictMapper.class);
            try {
                sysDictMapper.insertSysDict(sysDict);
                sqlSession.commit();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                sqlSession.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Saving dictionary failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Save dictionary successfully!").success(true).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Path(value="/edit")
    @SubmarineApi
    public Response edit(SysDict sysDict) {
        try (SqlSession sqlSession = MyBatisUtil.getSqlSession();){
            SysDictMapper sysDictMapper = (SysDictMapper)sqlSession.getMapper(SysDictMapper.class);
            SysDict dict = sysDictMapper.getById(sysDict.getId());
            if (dict == null) {
                Response response = new JsonResponse.Builder(Response.Status.OK).message("Can not found dict:" + sysDict.getId()).success(false).build();
                return response;
            }
            sysDictMapper.updateBy(sysDict);
            sqlSession.commit();
            return new JsonResponse.Builder(Response.Status.OK).message("Update the dictionary successfully!").success(true).build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Update dictionary failed!").success(false).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/delete")
    @SubmarineApi
    public Response delete(@QueryParam(value="id") String dictId, @QueryParam(value="deleted") int deleted) {
        String msgOperation = "Delete";
        if (deleted == 0) {
            msgOperation = "Restore";
        }
        try {
            SqlSession sqlSession = MyBatisUtil.getSqlSession();
            SysDictMapper sysDictMapper = (SysDictMapper)sqlSession.getMapper(SysDictMapper.class);
            try {
                SysDict dict = new SysDict();
                dict.setId(dictId);
                dict.setDeleted(deleted);
                sysDictMapper.updateBy(dict);
                sqlSession.commit();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                sqlSession.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message(msgOperation + " dictionary failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message(msgOperation + " the dictionary successfully!").success(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/remove")
    @SubmarineApi
    public Response remove(String dictId) {
        try {
            SqlSession sqlSession = MyBatisUtil.getSqlSession();
            SysDictMapper sysDictMapper = (SysDictMapper)sqlSession.getMapper(SysDictMapper.class);
            try {
                sysDictMapper.deleteById(dictId);
                sqlSession.commit();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                sqlSession.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new JsonResponse.Builder(Response.Status.OK).message("Delete dictionary failed!").success(false).build();
        }
        return new JsonResponse.Builder(Response.Status.OK).message("Delete the dictionary successfully!").success(true).build();
    }
}

